/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.web.conditions;

import com.atlassian.bitbucket.project.Project;
import com.atlassian.bitbucket.repository.RepositoryService;
import com.atlassian.bitbucket.util.Page;
import com.atlassian.plugin.PluginParseException;
import com.atlassian.plugin.web.Condition;
import java.util.Map;

public class NoRepositoriesExistForProjectCondition
implements Condition {
    static final String PROJECT = "project";
    static final String REPOSITORY_PAGE = "repositoryPage";
    private final RepositoryService repositoryService;

    public NoRepositoriesExistForProjectCondition(RepositoryService repositoryService) {
        this.repositoryService = repositoryService;
    }

    public void init(Map<String, String> params) throws PluginParseException {
    }

    public boolean shouldDisplay(Map<String, Object> context) {
        if (context.containsKey(REPOSITORY_PAGE)) {
            Object repositoryPage = context.get(REPOSITORY_PAGE);
            return repositoryPage instanceof Page && ((Page)repositoryPage).getSize() == 0;
        }
        Object project = context.get(PROJECT);
        return project instanceof Project && this.repositoryService.countByProject((Project)project) == 0;
    }
}

