package com.atlassian.cache;

import com.atlassian.annotations.PublicApi;

/**
 * A Resettable reference.
 *
 * @since 2.0
 */
@PublicApi
public interface CachedReference<V>
{
    /**
     * Get a value from the cache.
     *
     * @return the cached value
     */
    V get();

    /**
     * Resets (clears/invalidates) this reference.
     */
    void reset();
}
