package com.atlassian.cache;

import com.atlassian.annotations.Internal;

/**
 * Provides an implementation of the {@link CacheSettings} interface.
 * @since 2.0
 */
@Internal
class DefaultCacheSettings implements CacheSettings
{
    private final Long expireAfterAccess;
    private final Long expireAfterWrite;
    private final Boolean flushable;
    private final Boolean local;
    private final Integer maxEntries;
    private final Boolean replicateAsynchronously;
    private final Boolean replicateViaCopy;

    DefaultCacheSettings(Long expireAfterAccess, Long expireAfterWrite, Boolean flushable,
        Boolean local, Integer maxEntries, Boolean replicateAsynchronously, Boolean replicateViaCopy)
    {
        this.expireAfterAccess = expireAfterAccess;
        this.expireAfterWrite = expireAfterWrite;
        this.flushable = flushable;
        this.local = local;
        this.maxEntries = maxEntries;
        this.replicateAsynchronously = replicateAsynchronously;
        this.replicateViaCopy = replicateViaCopy;
    }

    @Override
    public CacheSettings override(CacheSettings overrides)
    {
        return new DefaultCacheSettings(
                notNullElse(overrides.getExpireAfterAccess(), expireAfterAccess),
                notNullElse(overrides.getExpireAfterWrite(), expireAfterWrite),
                notNullElse(overrides.getFlushable(), flushable),
                notNullElse(overrides.getLocal(), local),
                notNullElse(overrides.getMaxEntries(), maxEntries),
                notNullElse(overrides.getReplicateAsynchronously(), replicateAsynchronously),
                notNullElse(overrides.getReplicateViaCopy(), replicateViaCopy));
    }

    @Override
    public Long getExpireAfterAccess()
    {
        return expireAfterAccess;
    }
    @Override
    public long getExpireAfterAccess(long defaultValue)
    {
        return (null == getExpireAfterAccess()) ? defaultValue : getExpireAfterAccess();
    }

    @Override
    public Long getExpireAfterWrite()
    {
        return expireAfterWrite;
    }
    @Override
    public long getExpireAfterWrite(long defaultValue)
    {
        return (null == getExpireAfterWrite()) ? defaultValue : getExpireAfterWrite();
    }

    @Override
    public Boolean getFlushable()
    {
        return flushable;
    }

    @Override
    public boolean getFlushable(boolean defaultValue)
    {
        return (null == getFlushable()) ? defaultValue : getFlushable();
    }

    @Override
    public Boolean getLocal()
    {
        return local;
    }
    @Override
    public boolean getLocal(boolean defaultValue)
    {
        return (null == getLocal()) ? defaultValue : getLocal();
    }

    @Override
    public Integer getMaxEntries()
    {
        return maxEntries;
    }

    @Override
    public int getMaxEntries(int defaultValue)
    {
        return (null == getMaxEntries()) ? defaultValue : getMaxEntries();
    }

    @Override
    public Boolean getReplicateAsynchronously()
    {
        return replicateAsynchronously;
    }
    @Override
    public boolean getReplicateAsynchronously(boolean defaultValue)
    {
        return (null == getReplicateAsynchronously()) ? defaultValue : getReplicateAsynchronously();
    }

    @Override
    public Boolean getReplicateViaCopy()
    {
        return replicateViaCopy;
    }

    @Override
    public boolean getReplicateViaCopy(boolean defaultValue)
    {
        return (null == getReplicateViaCopy()) ? defaultValue : getReplicateViaCopy();
    }

    private static <T> T notNullElse(T value, T def)
    {
        return (null != value) ? value : def;
    }
}
