package com.atlassian.cache;

import com.atlassian.annotations.PublicApi;

import javax.annotation.Nonnull;

/**
 * An abstract adapter for {@code CacheEntryListener}.
 *
 * @since 2.4
 */
@PublicApi
public abstract class CacheEntryAdapter<K, V> implements CacheEntryListener<K, V>
{
    @Override
    public void onAdd(@Nonnull CacheEntryEvent<K, V> event)
    {
    }

    @Override
    public void onEvict(@Nonnull CacheEntryEvent<K, V> event)
    {
    }

    @Override
    public void onRemove(@Nonnull CacheEntryEvent<K, V> event)
    {
    }

    @Override
    public void onUpdate(@Nonnull CacheEntryEvent<K, V> event)
    {
    }
}
