/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.crowd.manager.application;

import com.atlassian.crowd.embedded.api.Directory;
import com.atlassian.crowd.manager.application.MembershipSearchStrategy;
import com.atlassian.crowd.manager.application.SingleDirectorySearchStrategy;
import com.atlassian.crowd.manager.directory.DirectoryManager;
import com.atlassian.crowd.model.group.Group;
import com.atlassian.crowd.model.user.User;
import com.atlassian.crowd.search.query.QueryUtils;
import com.atlassian.crowd.search.query.membership.MembershipQuery;
import com.google.common.collect.ImmutableList;
import java.util.List;

public abstract class AbstractInMemoryMembershipSearchStrategy
implements MembershipSearchStrategy {
    protected final DirectoryManager directoryManager;
    protected final List<Directory> directories;

    public AbstractInMemoryMembershipSearchStrategy(DirectoryManager directoryManager, List<Directory> directories) {
        this.directoryManager = directoryManager;
        this.directories = ImmutableList.copyOf(directories);
    }

    protected <T> List<T> doDirectDirectoryMembershipQuery(MembershipQuery<T> query, long directoryId) {
        return new SingleDirectorySearchStrategy(this.directoryManager, directoryId).searchDirectGroupRelationships(query);
    }

    protected <T> List<T> doNestedDirectoryMembershipQuery(MembershipQuery<T> query, long directoryId) {
        return new SingleDirectorySearchStrategy(this.directoryManager, directoryId).searchNestedGroupRelationships(query);
    }

    @Override
    public <T> List<T> searchDirectGroupRelationships(MembershipQuery<T> query) {
        QueryUtils.checkAssignableFrom((Class)query.getReturnType(), (Class[])new Class[]{String.class, Group.class, User.class});
        return this.searchGroupRelationships(query, this::doDirectDirectoryMembershipQuery);
    }

    @Override
    public <T> List<T> searchNestedGroupRelationships(MembershipQuery<T> query) {
        QueryUtils.checkAssignableFrom((Class)query.getReturnType(), (Class[])new Class[]{String.class, Group.class, User.class});
        return this.searchGroupRelationships(query, this::doNestedDirectoryMembershipQuery);
    }

    protected abstract <T> List<T> searchGroupRelationships(MembershipQuery<T> var1, Searcher<T> var2);

    protected static interface Searcher<T> {
        public List<T> search(MembershipQuery<T> var1, long var2);
    }
}

