/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.crowd.manager.application;

import com.atlassian.crowd.embedded.api.Directory;
import com.atlassian.crowd.exception.DirectoryNotFoundException;
import com.atlassian.crowd.exception.GroupNotFoundException;
import com.atlassian.crowd.exception.ObjectNotFoundException;
import com.atlassian.crowd.exception.OperationFailedException;
import com.atlassian.crowd.exception.UserNotFoundException;
import com.atlassian.crowd.manager.directory.DirectoryManager;
import com.atlassian.crowd.model.group.Group;
import com.atlassian.crowd.model.group.GroupWithAttributes;
import com.atlassian.crowd.model.user.User;
import com.atlassian.crowd.model.user.UserWithAttributes;
import com.google.common.collect.ImmutableList;
import java.util.ConcurrentModificationException;
import java.util.List;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CanonicalEntityByNameFinder {
    private static final Logger logger = LoggerFactory.getLogger(CanonicalEntityByNameFinder.class);
    private final DirectoryManager directoryManager;
    private final List<Directory> directories;

    public CanonicalEntityByNameFinder(DirectoryManager directoryManager, Iterable<Directory> directories) {
        this.directoryManager = directoryManager;
        this.directories = ImmutableList.copyOf(directories);
    }

    public Group fastFailingFindGroupByName(String name) throws GroupNotFoundException, OperationFailedException {
        return this.fastFailingFindOptionalGroupByName(name).orElseThrow(() -> new GroupNotFoundException(name));
    }

    public User fastFailingFindUserByName(String name) throws UserNotFoundException, OperationFailedException {
        return this.fastFailingFindOptionalUserByName(name).orElseThrow(() -> new UserNotFoundException(name));
    }

    public Optional<Group> fastFailingFindOptionalGroupByName(String name) throws OperationFailedException {
        return this.fastFailFindByName((arg_0, arg_1) -> ((DirectoryManager)this.directoryManager).findGroupByName(arg_0, arg_1), name);
    }

    public Optional<User> fastFailingFindOptionalUserByName(String name) throws OperationFailedException {
        return this.fastFailFindByName((arg_0, arg_1) -> ((DirectoryManager)this.directoryManager).findUserByName(arg_0, arg_1), name);
    }

    public Group findGroupByName(String name) throws GroupNotFoundException {
        return this.findByName((arg_0, arg_1) -> ((DirectoryManager)this.directoryManager).findGroupByName(arg_0, arg_1), name).orElseThrow(() -> new GroupNotFoundException(name));
    }

    public GroupWithAttributes findGroupWithAttributesByName(String name) throws GroupNotFoundException {
        return this.findByName((arg_0, arg_1) -> ((DirectoryManager)this.directoryManager).findGroupWithAttributesByName(arg_0, arg_1), name).orElseThrow(() -> new GroupNotFoundException(name));
    }

    public User findUserByName(String name) throws UserNotFoundException {
        return this.findByName((arg_0, arg_1) -> ((DirectoryManager)this.directoryManager).findUserByName(arg_0, arg_1), name).orElseThrow(() -> new UserNotFoundException(name));
    }

    public User findRemoteUserByName(String name) throws UserNotFoundException {
        return this.findByName((arg_0, arg_1) -> ((DirectoryManager)this.directoryManager).findRemoteUserByName(arg_0, arg_1), name).orElseThrow(() -> new UserNotFoundException(name));
    }

    public UserWithAttributes findUserWithAttributesByName(String name) throws UserNotFoundException {
        return this.findByName((arg_0, arg_1) -> ((DirectoryManager)this.directoryManager).findUserWithAttributesByName(arg_0, arg_1), name).orElseThrow(() -> new UserNotFoundException(name));
    }

    private <T> Optional<T> findByName(Searcher<T> searcher, String name) {
        for (Directory directory : this.directories) {
            try {
                return Optional.ofNullable(searcher.findByName(directory.getId(), name));
            }
            catch (ObjectNotFoundException objectNotFoundException) {
            }
            catch (OperationFailedException e) {
                logger.error(e.getMessage(), (Throwable)e);
            }
            catch (DirectoryNotFoundException e) {
                throw CanonicalEntityByNameFinder.concurrentModificationExceptionForDirectoryIteration(e);
            }
        }
        return Optional.empty();
    }

    private <T> Optional<T> fastFailFindByName(Searcher<T> searcher, String name) throws OperationFailedException {
        for (Directory directory : this.directories) {
            try {
                return Optional.ofNullable(searcher.findByName(directory.getId(), name));
            }
            catch (ObjectNotFoundException objectNotFoundException) {
            }
            catch (DirectoryNotFoundException e) {
                throw CanonicalEntityByNameFinder.concurrentModificationExceptionForDirectoryIteration(e);
            }
        }
        return Optional.empty();
    }

    private static ConcurrentModificationException concurrentModificationExceptionForDirectoryIteration(DirectoryNotFoundException e) {
        return new ConcurrentModificationException("Directory mapping was removed while iterating through directories", e);
    }

    private static interface Searcher<T> {
        public T findByName(long var1, String var3) throws DirectoryNotFoundException, OperationFailedException, ObjectNotFoundException;
    }
}

