/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.crowd.manager.application;

import com.atlassian.crowd.directory.DirectoryProperties;
import com.atlassian.crowd.embedded.api.Directory;
import com.atlassian.crowd.embedded.api.SearchRestriction;
import com.atlassian.crowd.embedded.impl.IdentifierSet;
import com.atlassian.crowd.embedded.impl.IdentifierUtils;
import com.atlassian.crowd.manager.application.SingleDirectorySearchStrategy;
import com.atlassian.crowd.manager.directory.DirectoryManager;
import com.atlassian.crowd.search.EntityDescriptor;
import com.atlassian.crowd.search.builder.QueryBuilder;
import com.atlassian.crowd.search.builder.Restriction;
import com.atlassian.crowd.search.query.entity.EntityQuery;
import com.atlassian.crowd.search.query.entity.restriction.NullRestriction;
import com.atlassian.crowd.search.query.entity.restriction.Property;
import com.atlassian.crowd.search.query.entity.restriction.constants.GroupTermKeys;
import com.atlassian.crowd.search.query.entity.restriction.constants.UserTermKeys;
import com.atlassian.crowd.search.util.QuerySplitter;
import com.google.common.base.Preconditions;
import com.google.common.collect.HashBasedTable;
import com.google.common.collect.HashMultimap;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Multimap;
import com.google.common.collect.Multimaps;
import com.google.common.collect.Table;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public class CanonicalityChecker {
    protected static final int BATCH_SIZE = 1000;
    private final DirectoryManager directoryManager;
    private final List<Directory> directories;
    private final boolean queryForAllEntities;
    private final Table<EntityDescriptor, String, Long> nameAndEntityToCanonicalDirId = HashBasedTable.create();
    private final Table<EntityDescriptor, Long, IdentifierSet> fullCache = HashBasedTable.create();

    public CanonicalityChecker(DirectoryManager directoryManager, List<Directory> directories, boolean queryForAllEntities) {
        this.directoryManager = directoryManager;
        this.directories = ImmutableList.copyOf(directories);
        this.queryForAllEntities = queryForAllEntities;
    }

    public void removeNonCanonicalEntities(Multimap<Long, String> allNames, EntityDescriptor entity) {
        Map nameToCanonicalDirId = this.nameAndEntityToCanonicalDirId.row((Object)entity);
        HashMultimap unknown = HashMultimap.create((Multimap)Multimaps.index((Iterable)allNames.values(), IdentifierUtils::toLowerCase));
        unknown.keySet().removeAll(nameToCanonicalDirId.keySet());
        for (Directory directory : this.directories) {
            long dirId = directory.getId();
            Iterator it = allNames.get((Object)dirId).iterator();
            while (it.hasNext()) {
                String lowerName = IdentifierUtils.toLowerCase((String)((String)it.next()));
                unknown.removeAll((Object)lowerName);
                long canonicalDirId = nameToCanonicalDirId.computeIfAbsent(lowerName, ignore -> dirId);
                if (canonicalDirId == dirId) continue;
                it.remove();
            }
            IdentifierSet found = this.findEntitiesInternal(unknown.values(), entity, directory);
            unknown.keySet().removeAll((Collection<?>)found);
            found.forEach(name -> nameToCanonicalDirId.put(name, dirId));
        }
    }

    private IdentifierSet findEntitiesInternal(Collection<String> candidates, EntityDescriptor entity, Directory directory) {
        if (candidates.isEmpty()) {
            return IdentifierSet.EMPTY;
        }
        if (this.queryForAllEntities && DirectoryProperties.cachesAllUsers((Directory)directory)) {
            IdentifierSet cached = this.fullCache.row((Object)entity).computeIfAbsent(directory.getId(), ignore -> this.search(entity, (SearchRestriction)NullRestriction.INSTANCE, directory));
            return IdentifierSet.intersection(candidates, (Collection)cached);
        }
        SearchRestriction restriction = Restriction.on((Property)(CanonicalityChecker.isUser(entity) ? UserTermKeys.USERNAME : GroupTermKeys.NAME)).exactlyMatchingAny(candidates);
        return this.search(entity, restriction, directory);
    }

    private IdentifierSet search(EntityDescriptor entity, SearchRestriction restriction, Directory directory) {
        EntityQuery query = QueryBuilder.queryFor(String.class, (EntityDescriptor)entity, (SearchRestriction)restriction, (int)0, (int)-1);
        SingleDirectorySearchStrategy searchStrategy = new SingleDirectorySearchStrategy(this.directoryManager, directory.getId());
        return new IdentifierSet((Collection)QuerySplitter.batchConditionsIfNeeded((EntityQuery)query, (QuerySplitter.Searcher)(CanonicalityChecker.isUser(entity) ? searchStrategy::searchUsers : searchStrategy::searchGroups), (int)1000));
    }

    private static boolean isUser(EntityDescriptor entity) {
        Preconditions.checkArgument((entity.equals((Object)EntityDescriptor.user()) || entity.equals((Object)EntityDescriptor.group()) ? 1 : 0) != 0);
        return entity.equals((Object)EntityDescriptor.user());
    }

    public List<Directory> getDirectories() {
        return this.directories;
    }
}

