/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.crowd.manager.application;

import com.atlassian.crowd.embedded.api.Directory;
import com.atlassian.crowd.manager.application.CanonicalityChecker;
import com.atlassian.crowd.manager.application.GroupSearchStrategy;
import com.atlassian.crowd.manager.application.InMemoryAggregatingMembershipSearchStrategy;
import com.atlassian.crowd.manager.application.InMemoryEntitySearchStrategy;
import com.atlassian.crowd.manager.application.InMemoryNonAggregatingMembershipSearchStrategy;
import com.atlassian.crowd.manager.application.MembershipSearchStrategy;
import com.atlassian.crowd.manager.application.NoDirectorySearchStrategy;
import com.atlassian.crowd.manager.application.SearchStrategyFactory;
import com.atlassian.crowd.manager.application.SingleDirectorySearchStrategy;
import com.atlassian.crowd.manager.application.UserSearchStrategy;
import com.atlassian.crowd.manager.directory.DirectoryManager;
import com.google.common.collect.Iterables;
import java.util.List;
import java.util.Objects;
import java.util.function.Supplier;

public class DefaultSearchStrategyFactory
implements SearchStrategyFactory {
    private final DirectoryManager directoryManager;

    public DefaultSearchStrategyFactory(DirectoryManager directoryManager) {
        this.directoryManager = Objects.requireNonNull(directoryManager, "directoryManager");
    }

    @Override
    public MembershipSearchStrategy createMembershipSearchStrategy(boolean aggregateMemberships, List<Directory> directories, CanonicalityChecker canonicalityChecker) {
        return this.getStrategy(directories, () -> aggregateMemberships ? new InMemoryAggregatingMembershipSearchStrategy(this.directoryManager, directories) : new InMemoryNonAggregatingMembershipSearchStrategy(this.directoryManager, directories, canonicalityChecker));
    }

    @Override
    public UserSearchStrategy createUserSearchStrategy(boolean mergeUsers, List<Directory> directories) {
        return this.getStrategy(directories, () -> new InMemoryEntitySearchStrategy(this.directoryManager, directories, mergeUsers));
    }

    @Override
    public GroupSearchStrategy createGroupSearchStrategy(boolean mergeGroups, List<Directory> directories) {
        return this.getStrategy(directories, () -> new InMemoryEntitySearchStrategy(this.directoryManager, directories, mergeGroups));
    }

    private <T> T getStrategy(List<Directory> directories, Supplier<T> supplier) {
        if (directories.isEmpty()) {
            return (T)NoDirectorySearchStrategy.INSTANCE;
        }
        if (directories.size() == 1) {
            return (T)new SingleDirectorySearchStrategy(this.directoryManager, ((Directory)Iterables.getOnlyElement(directories)).getId());
        }
        return supplier.get();
    }
}

