/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.crowd.manager.application;

import com.atlassian.crowd.embedded.api.Directory;
import com.atlassian.crowd.exception.ObjectNotFoundException;
import com.atlassian.crowd.manager.application.AbstractInMemoryMembershipSearchStrategy;
import com.atlassian.crowd.manager.application.CanonicalEntityByNameFinder;
import com.atlassian.crowd.manager.application.CanonicalityChecker;
import com.atlassian.crowd.manager.directory.DirectoryManager;
import com.atlassian.crowd.model.DirectoryEntity;
import com.atlassian.crowd.model.NameComparator;
import com.atlassian.crowd.search.EntityDescriptor;
import com.atlassian.crowd.search.query.membership.MembershipQuery;
import com.atlassian.crowd.search.util.ResultsAggregator;
import com.atlassian.crowd.search.util.ResultsAggregators;
import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import com.google.common.collect.HashMultimap;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Multimap;
import com.google.common.collect.Multimaps;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class InMemoryNonAggregatingMembershipSearchStrategy
extends AbstractInMemoryMembershipSearchStrategy {
    private static final Logger logger = LoggerFactory.getLogger(InMemoryNonAggregatingMembershipSearchStrategy.class);
    private CanonicalEntityByNameFinder canonicalEntityGetter;
    private CanonicalityChecker canonicalityFilter;

    public InMemoryNonAggregatingMembershipSearchStrategy(DirectoryManager directoryManager, List<Directory> directories, CanonicalityChecker canonicalityFilter) {
        super(directoryManager, directories);
        this.canonicalEntityGetter = new CanonicalEntityByNameFinder(directoryManager, directories);
        this.canonicalityFilter = canonicalityFilter == null ? new CanonicalityChecker(directoryManager, directories, false) : canonicalityFilter;
        Preconditions.checkArgument((canonicalityFilter == null || canonicalityFilter.getDirectories().equals(this.directories) ? 1 : 0) != 0);
    }

    @Override
    protected <T> List<T> searchGroupRelationships(MembershipQuery<T> query, AbstractInMemoryMembershipSearchStrategy.Searcher<T> searcher) {
        return query.isFindChildren() ? this.getChildren(query, searcher) : this.getParents(query, searcher);
    }

    private <T> List<T> getChildren(MembershipQuery<T> query, AbstractInMemoryMembershipSearchStrategy.Searcher<T> searcher) {
        HashMultimap allEntities = HashMultimap.create();
        MembershipQuery allResultsQuery = query.withAllResults();
        for (Directory directory : this.directories) {
            allEntities.putAll((Object)directory.getId(), searcher.search(allResultsQuery, directory.getId()));
        }
        this.canonicalityFilter.removeNonCanonicalEntities((Multimap<Long, String>)Multimaps.transformValues((Multimap)allEntities, (Function)NameComparator.nameGetter((Class)query.getReturnType())), query.getEntityToReturn());
        ResultsAggregator aggregator = ResultsAggregators.with(query);
        this.directories.forEach(arg_0 -> InMemoryNonAggregatingMembershipSearchStrategy.lambda$getChildren$0(aggregator, (Multimap)allEntities, arg_0));
        return aggregator.constrainResults();
    }

    private <T> List<T> getParents(MembershipQuery<T> query, AbstractInMemoryMembershipSearchStrategy.Searcher<T> searcher) {
        try {
            DirectoryEntity entity = this.findEntityByName(query.getEntityNameToMatch(), query.getEntityToMatch());
            return searcher.search(query, entity.getDirectoryId());
        }
        catch (ObjectNotFoundException e) {
            return ImmutableList.of();
        }
    }

    private DirectoryEntity findEntityByName(String entityName, EntityDescriptor entityDescriptor) throws ObjectNotFoundException {
        if (entityDescriptor == EntityDescriptor.user()) {
            return this.canonicalEntityGetter.findUserByName(entityName);
        }
        if (entityDescriptor == EntityDescriptor.group()) {
            return this.canonicalEntityGetter.findGroupByName(entityName);
        }
        throw new IllegalArgumentException("Expected a User or Group");
    }

    private static /* synthetic */ void lambda$getChildren$0(ResultsAggregator aggregator, Multimap allEntities, Directory dir) {
        aggregator.addAll((Iterable)allEntities.get((Object)dir.getId()));
    }
}

