/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.crowd.manager.application;

import com.atlassian.crowd.embedded.api.Query;
import com.atlassian.crowd.exception.DirectoryNotFoundException;
import com.atlassian.crowd.exception.OperationFailedException;
import com.atlassian.crowd.manager.application.GroupSearchStrategy;
import com.atlassian.crowd.manager.application.MembershipSearchStrategy;
import com.atlassian.crowd.manager.application.UserSearchStrategy;
import com.atlassian.crowd.manager.directory.DirectoryManager;
import com.atlassian.crowd.search.query.entity.EntityQuery;
import com.atlassian.crowd.search.query.membership.MembershipQuery;
import java.util.Collections;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SingleDirectorySearchStrategy
implements UserSearchStrategy,
GroupSearchStrategy,
MembershipSearchStrategy {
    private static final Logger logger = LoggerFactory.getLogger(SingleDirectorySearchStrategy.class);
    private final DirectoryManager directoryManager;
    private final long directoryId;

    public SingleDirectorySearchStrategy(DirectoryManager directoryManager, long directoryId) {
        this.directoryManager = directoryManager;
        this.directoryId = directoryId;
    }

    @Override
    public <T> List<T> searchUsers(EntityQuery<T> query) {
        return this.search((arg_0, arg_1) -> ((DirectoryManager)this.directoryManager).searchUsers(arg_0, arg_1), (Query)query);
    }

    @Override
    public <T> List<T> searchGroups(EntityQuery<T> query) {
        return this.search((arg_0, arg_1) -> ((DirectoryManager)this.directoryManager).searchGroups(arg_0, arg_1), (Query)query);
    }

    @Override
    public <T> List<T> searchDirectGroupRelationships(MembershipQuery<T> query) {
        return this.search((arg_0, arg_1) -> ((DirectoryManager)this.directoryManager).searchDirectGroupRelationships(arg_0, arg_1), (Query)query);
    }

    @Override
    public <T> List<T> searchNestedGroupRelationships(MembershipQuery<T> query) {
        return this.search((arg_0, arg_1) -> ((DirectoryManager)this.directoryManager).searchNestedGroupRelationships(arg_0, arg_1), (Query)query);
    }

    private <T, Q extends Query<T>> List<T> search(Searcher<T, Q> searcher, Q query) {
        try {
            return searcher.search(this.directoryId, query);
        }
        catch (DirectoryNotFoundException directoryNotFoundException) {
        }
        catch (OperationFailedException e) {
            logger.error("Failed to search underlying directory", (Throwable)e);
        }
        return Collections.emptyList();
    }

    private static interface Searcher<T, Q extends Query<T>> {
        public List<T> search(long var1, Q var3) throws DirectoryNotFoundException, OperationFailedException;
    }
}

