/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.crowd.manager.application.resilience;

import com.atlassian.crowd.embedded.api.Directory;
import com.atlassian.crowd.manager.application.resilience.NullResilienceStrategy;
import com.atlassian.crowd.manager.application.resilience.ResilienceStrategy;
import com.atlassian.crowd.manager.application.resilience.RetryWithBackoffResilienceStrategy;

public class ResilienceStrategySelector {
    public static final String DIRECTORY_RESILIENCE_MAX_RETRIES = "crowd.directory.resilience.maxRetries";
    public static final String DIRECTORY_RESILIENCE_MIN_BACKOFF_DELAY = "crowd.directory.resilience.minBackoffMillis";
    public static final String DIRECTORY_RESILIENCE_MAX_BACKOFF_DELAY = "crowd.directory.resilience.maxBackoffMillis";

    public static <T> ResilienceStrategy<T> getResilienceStrategy(Directory directory) {
        int maxRetries = ResilienceStrategySelector.getAttributeValueAsLong(directory, DIRECTORY_RESILIENCE_MAX_RETRIES);
        if (maxRetries == 0) {
            return new NullResilienceStrategy();
        }
        int minBackoffMillis = ResilienceStrategySelector.getAttributeValueAsLong(directory, DIRECTORY_RESILIENCE_MIN_BACKOFF_DELAY);
        int maxBackoffMillis = ResilienceStrategySelector.getAttributeValueAsLong(directory, DIRECTORY_RESILIENCE_MAX_BACKOFF_DELAY);
        return new RetryWithBackoffResilienceStrategy(maxRetries, minBackoffMillis, maxBackoffMillis);
    }

    private static int getAttributeValueAsLong(Directory directory, String attributeName) {
        String value = directory.getValue(attributeName);
        return value == null ? 0 : Math.max(0, Integer.parseInt(value));
    }
}

