package com.atlassian.crowd.model.application;

/**
 * Constants for attributes of an application.
 *
 * @since v2.1
 */
public class ApplicationAttributeConstants {
    /**
     * Key of attribute indicating whether the application password has been encoded with the Atlassian SHA1 algorithm.
     */
    public static final String ATTRIBUTE_KEY_ATLASSIAN_SHA1_APPLIED = "atlassian_sha1_applied";

    /**
     * Key of attribute storing the value of the Application URL.
     */
    public static final String ATTRIBUTE_KEY_APPLICATION_URL = "applicationURL";

    /**
     * Key of attribute indicating whether the user and group names returned should be in lowercase.
     */
    public static final String ATTRIBUTE_KEY_LOWER_CASE_OUTPUT = "lowerCaseOutput";

    /**
     * Key of attribute indicating whether aliasing is enabled for the application.
     */
    public static final String ATTRIBUTE_KEY_ALIASING_ENABLED = "aliasingEnabled";

    /**
     * Key of attribute indicating whether memberships are aggregated across mapped directories.
     */
    public static final String ATTRIBUTE_KEY_AGGREGATE_MEMBERSHIPS = "aggregateMemberships";

    /**
     * Key of attribute indicating the application link ID
     */
    public static final String ATTRIBUTE_KEY_APPLICATION_LINK_ID = "applicationLinkId";

    /**
     * Key of attribute indicating the value of the interval for licensing data sync interval
     */
    public static final String ATTRIBUTE_KEY_LICENSE_DATA_SYNC_INTERVAL_IN_MIN = "licenseDataSyncInterval";

    /**
     * Key of attribute indicating the value of the last license data sync state
     */
    public static final String ATTRIBUTE_KEY_LAST_LICENSE_DATA_SYNC_STATUS = "lastLicenseDataSyncStatus";

    /**
     * Key of attribute indicating the timestamp when last license data sync state was updated
     */
    public static final String ATTRIBUTE_KEY_LAST_LICENSE_DATA_SYNC_STATUS_TIMESTAMP = "lastLicenseDataSyncStatusTimestamp";

    private ApplicationAttributeConstants() {
    } // prevent instantiation
}
