package com.atlassian.crowd.integration.springsecurity;

import com.atlassian.crowd.model.user.User;
import org.springframework.security.authentication.AbstractAuthenticationToken;
import org.springframework.security.core.GrantedAuthority;

import java.util.Collection;

public class CrowdRememberMeAuthentication extends AbstractAuthenticationToken {

    private static final String REMEMBER_ME_CRED = "REMEMBERME.CREDS";
    private Object principal;

    public CrowdRememberMeAuthentication(User principal) {
        super(null);
        this.principal = principal;
        super.setAuthenticated(false);
    }

    public CrowdRememberMeAuthentication(Object principal, Collection<? extends GrantedAuthority> authorities) {
        super(authorities);
        this.principal = principal;
        super.setAuthenticated(true);
    }

    @Override
    public Object getCredentials() {
        return REMEMBER_ME_CRED;
    }

    @Override
    public Object getPrincipal() {
        return principal;
    }

    /**
     * Disallow setAuthenticated(true).
     * <p>
     * Use constructor containing GrantedAuthority[]s instead.
     *
     * @param isAuthenticated must be <code>false</code>.
     * @throws IllegalArgumentException throwd if isAuthenticated paramater is set to <code>true</code>.
     */
    @Override
    public void setAuthenticated(boolean isAuthenticated) throws IllegalArgumentException {
        if (isAuthenticated) {
            throw new IllegalArgumentException("Cannot set this token to trusted - use constructor containing GrantedAuthority[]s instead");
        }

        super.setAuthenticated(false);
    }
}
