package com.atlassian.crowd.integration.springsecurity;

import org.springframework.security.core.GrantedAuthority;

import java.util.Objects;

/**
 * This granted authority is assigned to users authenticated to applications defined in Crowd, other than the Crowd
 * application.
 */
public final class CrowdApplicationModuleGrantedAuthority implements GrantedAuthority {

    private static final String AUTHORITY_PREFIX = "APPLICATION_";
    private final String applicationName;

    public CrowdApplicationModuleGrantedAuthority(String applicationName) {
        this.applicationName = applicationName;
    }

    @Override
    public String getAuthority() {
        return AUTHORITY_PREFIX + applicationName;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        CrowdApplicationModuleGrantedAuthority that = (CrowdApplicationModuleGrantedAuthority) o;
        return Objects.equals(applicationName, that.applicationName);
    }

    @Override
    public int hashCode() {
        return Objects.hash(applicationName);
    }
}
