/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.crowd.directory;

import com.atlassian.crowd.directory.LdapContextSourceFactory;
import com.atlassian.crowd.directory.SpringLdapPoolStatistics;
import com.atlassian.crowd.directory.SpringLdapPoolStatisticsProvider;
import com.atlassian.crowd.directory.ldap.LDAPPropertiesMapper;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.Maps;
import java.util.Map;
import java.util.concurrent.ConcurrentMap;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.DisposableBean;
import org.springframework.ldap.core.ContextSource;
import org.springframework.ldap.pool2.factory.PooledContextSource;

public class SpringLdapPooledContextSourceProvider
implements DisposableBean,
SpringLdapPoolStatisticsProvider {
    private static final Logger logger = LoggerFactory.getLogger(SpringLdapPooledContextSourceProvider.class);
    private final LdapContextSourceFactory ldapContextSourceFactory;
    private final ConcurrentMap<Long, ContextSourceEntry> contextSources;

    public SpringLdapPooledContextSourceProvider(LdapContextSourceFactory ldapContextSourceFactory) {
        this.ldapContextSourceFactory = ldapContextSourceFactory;
        this.contextSources = Maps.newConcurrentMap();
    }

    @VisibleForTesting
    SpringLdapPooledContextSourceProvider(LdapContextSourceFactory ldapContextSourceFactory, ConcurrentMap<Long, ContextSourceEntry> contextSources) {
        this.ldapContextSourceFactory = ldapContextSourceFactory;
        this.contextSources = contextSources;
    }

    ContextSource getContextSource(long directoryId, LDAPPropertiesMapper ldapPropertiesMapper, Map<String, Object> envProperties) {
        ContextSourceEntry contestSourceEntry = (ContextSourceEntry)this.contextSources.get(directoryId);
        if (contestSourceEntry != null && this.hasSameAttributesAndProperties(contestSourceEntry, ldapPropertiesMapper, envProperties)) {
            return contestSourceEntry.contextSource;
        }
        return this.contextSources.compute(directoryId, (id, existingEntry) -> this.mergeEntries(directoryId, (ContextSourceEntry)existingEntry, ldapPropertiesMapper, envProperties)).contextSource;
    }

    private ContextSourceEntry mergeEntries(long directoryId, ContextSourceEntry existingEntry, LDAPPropertiesMapper ldapPropertiesMapper, Map<String, Object> envProperties) {
        if (existingEntry != null) {
            if (this.hasSameAttributesAndProperties(existingEntry, ldapPropertiesMapper, envProperties)) {
                return existingEntry;
            }
            try {
                existingEntry.contextSource.destroy();
            }
            catch (Exception e) {
                logger.error("Failed to destroy contextSource", (Throwable)e);
            }
        }
        logger.debug("Allocating new ldap pool for directory {}", (Object)directoryId);
        PooledContextSource contextSource = this.ldapContextSourceFactory.createPooledContextSource(directoryId, ldapPropertiesMapper, envProperties);
        return new ContextSourceEntry(contextSource, ldapPropertiesMapper, envProperties);
    }

    public void destroy() throws Exception {
        Exception lastException = null;
        for (ContextSourceEntry value : this.contextSources.values()) {
            try {
                value.contextSource.destroy();
            }
            catch (Exception e) {
                lastException = e;
            }
        }
        if (lastException != null) {
            throw lastException;
        }
    }

    @Override
    public Map<Long, SpringLdapPoolStatistics> getPoolStatistics() {
        return this.contextSources.entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, entry -> SpringLdapPoolStatistics.fromPool(((ContextSourceEntry)entry.getValue()).contextSource)));
    }

    private boolean hasSameAttributesAndProperties(ContextSourceEntry contextSourceEntry, LDAPPropertiesMapper attributes, Map<String, Object> envProperties) {
        return this.ldapContextSourceFactory.areConnectionPropertiesSame(attributes, contextSourceEntry.attributes) && contextSourceEntry.envProperties.equals(envProperties);
    }

    @VisibleForTesting
    static class ContextSourceEntry {
        private final PooledContextSource contextSource;
        private final LDAPPropertiesMapper attributes;
        private final Map<String, Object> envProperties;

        ContextSourceEntry(PooledContextSource contextSource, LDAPPropertiesMapper attributes, Map<String, Object> envProperties) {
            this.contextSource = contextSource;
            this.attributes = attributes;
            this.envProperties = envProperties;
        }
    }
}

