/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.crowd.directory.ldap.util;

import com.atlassian.crowd.directory.ldap.name.CrowdLdapName;
import com.atlassian.crowd.directory.ldap.name.CrowdLdapNameFactory;
import com.atlassian.crowd.embedded.impl.IdentifierUtils;

public class DNStandardiser {
    private static final CrowdLdapNameFactory LDAP_NAME_FACTORY = CrowdLdapNameFactory.getInstance();

    public static String standardise(String dn, boolean forceProperStandard) {
        if (forceProperStandard) {
            return DNStandardiser.standardiseToName(dn, true).toString();
        }
        return IdentifierUtils.toLowerCase((String)dn);
    }

    public static CrowdLdapName standardiseToName(String dn, boolean forceProperStandard) {
        CrowdLdapName lowerName = LDAP_NAME_FACTORY.get(IdentifierUtils.toLowerCase((String)dn));
        if (forceProperStandard) {
            return LDAP_NAME_FACTORY.get(lowerName.getRdns());
        }
        return lowerName;
    }

    public static CrowdLdapName ensureNameIsStandardised(CrowdLdapName name, boolean forceProperStandard) {
        CrowdLdapName lowerName = LDAP_NAME_FACTORY.get(IdentifierUtils.toLowerCase((String)name.toString()));
        if (forceProperStandard) {
            return LDAP_NAME_FACTORY.get(lowerName.getRdns());
        }
        return lowerName;
    }
}

