/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.crowd.directory.ldap.mapper.attribute.group;

import com.atlassian.crowd.directory.ldap.mapper.NameAttributesPair;
import com.atlassian.crowd.directory.ldap.mapper.attribute.AttributeMapper;
import com.atlassian.crowd.directory.ldap.util.RangeOption;
import com.google.common.collect.ImmutableSet;
import java.util.Collections;
import java.util.Set;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;

public class RFC4519MemberDnRangeOffsetMapper
implements AttributeMapper {
    public static final String ATTRIBUTE_KEY = "memberRangeStart";
    private final String groupMemberAttribute;
    private final String groupMemberPrefix;

    public RFC4519MemberDnRangeOffsetMapper(String groupMemberAttribute) {
        this.groupMemberAttribute = groupMemberAttribute;
        this.groupMemberPrefix = groupMemberAttribute + ";";
    }

    @Override
    public String getKey() {
        return ATTRIBUTE_KEY;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Set<String> getValues(NameAttributesPair nameAttributesPair) throws NamingException {
        try (NamingEnumeration<String> attrEnum = nameAttributesPair.getAttributes().getIDs();){
            while (attrEnum.hasMore()) {
                String attrId = attrEnum.next();
                if (!attrId.startsWith(this.groupMemberPrefix)) continue;
                RangeOption range = RangeOption.parse(attrId.split(";")[1]);
                int newStart = range.getTerminal() + 1;
                ImmutableSet immutableSet = ImmutableSet.of((Object)String.valueOf(newStart));
                return immutableSet;
            }
        }
        return ImmutableSet.of();
    }

    @Override
    public Set<String> getRequiredLdapAttributes() {
        return Collections.singleton(this.groupMemberAttribute);
    }
}

