/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.crowd.directory.ldap.mapper.attribute.group;

import com.atlassian.crowd.directory.ldap.mapper.NameAttributesPair;
import com.atlassian.crowd.directory.ldap.mapper.attribute.AttributeMapper;
import com.atlassian.crowd.directory.ldap.util.DNStandardiser;
import com.google.common.collect.ImmutableSet;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;

public class RFC4519MemberDnRangedMapper
implements AttributeMapper {
    public static final String ATTRIBUTE_KEY = "memberDNs";
    private final String groupMemberAttribute;
    private final String groupMemberPrefix;
    private final boolean relaxedDnStandardisation;

    public RFC4519MemberDnRangedMapper(String groupMemberAttribute, boolean relaxedDnStandardisation) {
        this.groupMemberAttribute = groupMemberAttribute;
        this.groupMemberPrefix = groupMemberAttribute + ";";
        this.relaxedDnStandardisation = relaxedDnStandardisation;
    }

    @Override
    public String getKey() {
        return ATTRIBUTE_KEY;
    }

    @Override
    public Set<String> getValues(NameAttributesPair nameAttributesPair) throws Exception {
        List<String> memberList = nameAttributesPair.getAttributeValuesForName(this.groupMemberAttribute);
        if (memberList == null) {
            return ImmutableSet.of();
        }
        Set<String> members = memberList.isEmpty() ? this.getInitialRangedMembers(nameAttributesPair) : ImmutableSet.copyOf(memberList);
        ImmutableSet.Builder standardDnSetBuilder = ImmutableSet.builderWithExpectedSize((int)members.size());
        Iterator iterator = members.iterator();
        while (iterator.hasNext()) {
            String memberDn = (String)iterator.next();
            String standardisedDn = DNStandardiser.standardise(memberDn, !this.relaxedDnStandardisation);
            standardDnSetBuilder.add((Object)standardisedDn);
        }
        return standardDnSetBuilder.build();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Set<String> getInitialRangedMembers(NameAttributesPair nameAttributesPair) throws NamingException {
        try (NamingEnumeration<String> attrEnum = nameAttributesPair.getAttributes().getIDs();){
            while (attrEnum.hasMore()) {
                String attrId = attrEnum.next();
                if (!attrId.startsWith(this.groupMemberPrefix)) continue;
                ImmutableSet immutableSet = ImmutableSet.copyOf(nameAttributesPair.getAttributeValuesForName(attrId));
                return immutableSet;
            }
        }
        return ImmutableSet.of();
    }

    @Override
    public Set<String> getRequiredLdapAttributes() {
        return Collections.singleton(this.groupMemberAttribute);
    }
}

