/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.crowd.directory.ldap.mapper.attribute.user;

import com.atlassian.crowd.directory.ldap.mapper.NameAttributesPair;
import com.atlassian.crowd.directory.ldap.mapper.attribute.AttributeMapper;
import com.atlassian.crowd.directory.ldap.util.DNStandardiser;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public class MemberOfOverlayMapper
implements AttributeMapper {
    public static final String ATTRIBUTE_KEY = "memberOf";
    private final String userMemberOfAttribute;
    private final boolean relaxedDnStandardisation;

    public MemberOfOverlayMapper(String userMemberOfAttribute, boolean relaxedDnStandardisation) {
        this.userMemberOfAttribute = userMemberOfAttribute;
        this.relaxedDnStandardisation = relaxedDnStandardisation;
    }

    @Override
    public String getKey() {
        return ATTRIBUTE_KEY;
    }

    @Override
    public Set<String> getValues(NameAttributesPair nameAttributesPair) throws Exception {
        List<String> memberships = nameAttributesPair.getAttributeValuesForName(this.userMemberOfAttribute);
        if (memberships != null) {
            HashSet<String> standardDNs = new HashSet<String>(memberships.size());
            for (String memberDN : memberships) {
                String dn = DNStandardiser.standardise(memberDN, !this.relaxedDnStandardisation);
                standardDNs.add(dn);
            }
            return standardDNs;
        }
        return Collections.emptySet();
    }

    @Override
    public Set<String> getRequiredLdapAttributes() {
        return Collections.singleton(this.userMemberOfAttribute);
    }
}

