/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.crowd.directory.ldap;

import com.atlassian.crowd.directory.ldap.mapper.NameAttributesPair;
import com.atlassian.crowd.directory.ldap.name.CrowdLdapName;
import com.atlassian.crowd.directory.ldap.name.CrowdLdapNameFactory;
import javax.naming.Name;
import javax.naming.directory.Attributes;
import org.springframework.ldap.core.ContextMapper;
import org.springframework.ldap.core.ContextSource;
import org.springframework.ldap.core.LdapTemplate;

public class CrowdLdapTemplate
extends LdapTemplate {
    private final CrowdLdapNameFactory ldapNameFactory = CrowdLdapNameFactory.getInstance();

    public CrowdLdapTemplate(ContextSource contextSource) {
        super(contextSource);
    }

    public <T> T lookup(Name dn, String[] attributes, ContextMapper<T> mapper) {
        return (T)this.executeReadOnly(ctx -> {
            Attributes filteredAttributes = ctx.getAttributes(dn, attributes);
            CrowdLdapName name = dn instanceof CrowdLdapName ? (CrowdLdapName)((Object)dn) : this.ldapNameFactory.get(dn.toString());
            NameAttributesPair nameAttributesPair = new NameAttributesPair(name, filteredAttributes);
            return mapper.mapFromContext((Object)nameAttributesPair);
        });
    }
}

