/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.crowd.directory.synchronisation.cache;

import com.atlassian.crowd.directory.ldap.name.CrowdLdapName;
import com.atlassian.crowd.directory.ldap.name.CrowdLdapNameFactory;
import com.atlassian.crowd.directory.ldap.name.LdapNameFormatException;
import com.atlassian.crowd.model.LDAPDirectoryEntity;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Maps;
import java.util.Collection;
import java.util.Map;

public class LDAPEntityNameMap<T extends LDAPDirectoryEntity> {
    private final CrowdLdapNameFactory ldapNameFactory = CrowdLdapNameFactory.getInstance();
    @VisibleForTesting
    final Map<String, String> guidMap = Maps.newHashMap();
    @VisibleForTesting
    final Map<String, String> dnMap = Maps.newHashMap();
    @VisibleForTesting
    final Map<String, String> guidToDnMap = Maps.newHashMap();

    public void putAll(Collection<T> entities) {
        for (LDAPDirectoryEntity ldapEntity : entities) {
            this.put(ldapEntity);
        }
    }

    public void put(T ldapEntity) {
        String objectGUID = ldapEntity.getValue("objectGUID");
        String dn = this.guidToDnMap.get(objectGUID);
        if (dn != null) {
            this.dnMap.remove(dn);
        }
        this.guidToDnMap.put(objectGUID, ldapEntity.getDn());
        this.guidMap.put(objectGUID, ldapEntity.getName());
        this.dnMap.put(ldapEntity.getDn(), ldapEntity.getName());
    }

    public void removeByGuid(String guid) {
        this.guidMap.remove(guid);
        String dn = this.guidToDnMap.get(guid);
        this.dnMap.remove(dn);
        this.guidToDnMap.remove(guid);
    }

    public void removeAllByGuid(Collection<String> guids) {
        for (String guid : guids) {
            this.removeByGuid(guid);
        }
    }

    public String getByDn(String dn) {
        return this.dnMap.get(dn);
    }

    public String getByGuid(String guid) {
        return this.guidMap.get(guid);
    }

    public void clear() {
        this.guidMap.clear();
        this.dnMap.clear();
        this.guidToDnMap.clear();
    }

    public Map<CrowdLdapName, String> toLdapNameKeyedMap() throws LdapNameFormatException {
        ImmutableMap.Builder builder = ImmutableMap.builder();
        for (Map.Entry<String, String> e : this.dnMap.entrySet()) {
            builder.put((Object)this.ldapNameFactory.get(e.getKey()), (Object)e.getValue());
        }
        return builder.build();
    }
}

