/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.crowd.directory.synchronisation.cache;

import com.atlassian.crowd.directory.synchronisation.cache.GroupUserCache;
import com.atlassian.crowd.model.group.LDAPGroupWithAttributes;
import com.atlassian.crowd.model.user.LDAPUserWithAttributes;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;

class LdapIncrSyncDetails {
    private Collection<LDAPGroupWithAttributes> retrievedGroups;
    private Collection<LDAPUserWithAttributes> retrievedUsers;
    private final Set<String> groupsDnsToUpdate = new HashSet<String>();
    private final Set<String> primaryGroupSids = new HashSet<String>();

    LdapIncrSyncDetails() {
    }

    public void setRetrievedGroups(Collection<LDAPGroupWithAttributes> retrievedGroups) {
        this.retrievedGroups = new ArrayList<LDAPGroupWithAttributes>(retrievedGroups);
    }

    public void setRetrievedUsers(Collection<LDAPUserWithAttributes> retrievedUsers) {
        this.retrievedUsers = new ArrayList<LDAPUserWithAttributes>(retrievedUsers);
    }

    public void addGroupDnsToUpdate(Set<String> groupDns) {
        this.groupsDnsToUpdate.addAll(groupDns);
    }

    public void addPrimaryGroupSidToUpdate(String primaryGroupSid) {
        this.primaryGroupSids.add(primaryGroupSid);
    }

    public Collection<LDAPGroupWithAttributes> getRetrievedGroups() {
        if (this.retrievedGroups == null) {
            this.retrievedGroups = new ArrayList<LDAPGroupWithAttributes>();
        }
        return this.retrievedGroups;
    }

    public Collection<LDAPUserWithAttributes> getRetrievedUsers() {
        if (this.retrievedUsers == null) {
            this.retrievedUsers = new ArrayList<LDAPUserWithAttributes>();
        }
        return this.retrievedUsers;
    }

    public Set<String> getGroupsDnsToUpdate() {
        return this.groupsDnsToUpdate;
    }

    public Set<String> getPrimaryGroupSids() {
        return this.primaryGroupSids;
    }

    public GroupUserCache toGroupUserCache() {
        return new GroupUserCache(false, true, true, this.getRetrievedGroups(), this.getRetrievedUsers());
    }
}

