/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.crowd.directory;

import com.atlassian.crowd.embedded.api.Directory;
import com.atlassian.crowd.manager.directory.SynchronisationMode;
import com.atlassian.crowd.model.directory.DirectorySynchronisationStatus;
import com.atlassian.crowd.model.directory.SynchronisationStatusKey;
import java.io.Serializable;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.StringJoiner;
import java.util.function.Function;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DirectorySynchronisationStatusImpl
implements DirectorySynchronisationStatus {
    private Integer id;
    private Directory directory;
    private Long startTimestamp;
    private Long endTimestamp;
    private SynchronisationStatusKey status;
    private String statusParameters;
    private String incrementalSyncError;
    private String fullSyncError;
    private String nodeId;
    private String nodeName;

    public DirectorySynchronisationStatusImpl() {
    }

    protected DirectorySynchronisationStatusImpl(Builder builder) {
        this.id = builder.id;
        this.directory = builder.directory;
        this.startTimestamp = builder.startTimestamp;
        this.endTimestamp = builder.endTimestamp;
        this.status = builder.status;
        this.statusParameters = builder.statusParameters;
        this.incrementalSyncError = builder.incrementalSyncError;
        this.fullSyncError = builder.fullSyncError;
        this.nodeId = builder.nodeId;
        this.nodeName = builder.nodeName;
    }

    public Integer getId() {
        return this.id;
    }

    public void setId(Integer id) {
        this.id = id;
    }

    public Directory getDirectory() {
        return this.directory;
    }

    public void setDirectory(Directory directory) {
        this.directory = directory;
    }

    public long getStartTimestamp() {
        return this.startTimestamp;
    }

    public void setStartTimestamp(long start) {
        this.startTimestamp = start;
    }

    public Long getEndTimestamp() {
        return this.endTimestamp;
    }

    public void setEndTimestamp(Long end) {
        this.endTimestamp = end;
    }

    public SynchronisationStatusKey getStatus() {
        return this.status;
    }

    public void setStatus(SynchronisationStatusKey status) {
        this.status = status;
    }

    public String getStatusParameters() {
        return this.statusParameters;
    }

    public void setStatusParameters(String statusParameters) {
        this.statusParameters = statusParameters;
    }

    public String getIncrementalSyncError() {
        return this.incrementalSyncError;
    }

    public void setIncrementalSyncError(String incrementalSyncError) {
        this.incrementalSyncError = incrementalSyncError;
    }

    public String getFullSyncError() {
        return this.fullSyncError;
    }

    public void setFullSyncError(String fullSyncError) {
        this.fullSyncError = fullSyncError;
    }

    public String getNodeId() {
        return this.nodeId;
    }

    public void setNodeId(String nodeId) {
        this.nodeId = nodeId;
    }

    public String getNodeName() {
        return this.nodeName;
    }

    public void setNodeName(String nodeName) {
        this.nodeName = nodeName;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DirectorySynchronisationStatusImpl that = (DirectorySynchronisationStatusImpl)o;
        return Objects.equals(this.id, that.id) && Objects.equals(this.directory, that.directory) && Objects.equals(this.startTimestamp, that.startTimestamp) && Objects.equals(this.endTimestamp, that.endTimestamp) && this.status == that.status && Objects.equals(this.statusParameters, that.statusParameters) && Objects.equals(this.incrementalSyncError, that.incrementalSyncError) && Objects.equals(this.fullSyncError, that.fullSyncError) && Objects.equals(this.nodeId, that.nodeId) && Objects.equals(this.nodeName, that.nodeName);
    }

    public int hashCode() {
        return Objects.hash(this.id, this.directory, this.startTimestamp, this.endTimestamp, this.status, this.statusParameters, this.incrementalSyncError, this.fullSyncError, this.nodeId, this.nodeName);
    }

    public String toString() {
        return new StringJoiner(", ", DirectorySynchronisationStatusImpl.class.getSimpleName() + "[", "]").add("id=" + this.id).add("directory=" + String.valueOf(Optional.ofNullable(this.directory).map(Directory::getId).orElse(null))).add("startTimestamp=" + this.startTimestamp).add("endTimestamp=" + this.endTimestamp).add("status=" + String.valueOf(this.status)).add("statusParameters=" + this.statusParameters).add("incrementalSyncError=" + this.incrementalSyncError).add("fullSyncError=" + this.fullSyncError).add("nodeId=" + this.nodeId).add("nodeName=" + this.nodeName).toString();
    }

    public static Builder builder(StatusParametersMarshaller statusParametersToMapper) {
        return new Builder(statusParametersToMapper);
    }

    public static Builder builder(DirectorySynchronisationStatus status, StatusParametersMarshaller statusParametersToMapper) {
        return new Builder(status, statusParametersToMapper);
    }

    public static class Builder {
        private static final Logger logger = LoggerFactory.getLogger(Builder.class);
        private Integer id;
        private Directory directory;
        private Long startTimestamp;
        private Long endTimestamp;
        private SynchronisationStatusKey status;
        private String statusParameters;
        private String incrementalSyncError;
        private String fullSyncError;
        private String nodeId;
        private String nodeName;
        private final StatusParametersMarshaller statusParametersMarshaller;

        public Builder(StatusParametersMarshaller statusParametersToMapper) {
            this.statusParametersMarshaller = statusParametersToMapper;
        }

        public Builder(DirectorySynchronisationStatus status, StatusParametersMarshaller statusParametersMarshaller) {
            this.id = status.getId();
            this.directory = status.getDirectory();
            this.startTimestamp = status.getStartTimestamp();
            this.endTimestamp = status.getEndTimestamp();
            this.status = status.getStatus();
            this.statusParameters = status.getStatusParameters();
            this.incrementalSyncError = status.getIncrementalSyncError();
            this.fullSyncError = status.getFullSyncError();
            this.nodeId = status.getNodeId();
            this.nodeName = status.getNodeName();
            this.statusParametersMarshaller = statusParametersMarshaller;
        }

        public Builder setId(Integer id) {
            this.id = id;
            return this;
        }

        public Builder setDirectory(Directory directory) {
            this.directory = directory;
            return this;
        }

        public Builder setStartTimestamp(Long startTimestamp) {
            this.startTimestamp = startTimestamp;
            return this;
        }

        public Builder setEndTimestamp(Long endTimestamp) {
            this.endTimestamp = endTimestamp;
            return this;
        }

        public Builder setStatus(SynchronisationStatusKey status, List<Serializable> statusParameters) {
            this.status = status;
            this.statusParameters = (String)this.statusParametersMarshaller.apply(statusParameters);
            return this;
        }

        public Builder setStatus(SynchronisationStatusKey status, String statusParameters) {
            this.status = status;
            this.statusParameters = statusParameters;
            return this;
        }

        public Builder setSyncError(SynchronisationMode syncMode, String errorMessage) {
            switch (syncMode) {
                case FULL: {
                    this.fullSyncError = errorMessage;
                    break;
                }
                case INCREMENTAL: {
                    this.incrementalSyncError = errorMessage;
                    break;
                }
                default: {
                    logger.warn("Got synchronization error for mode {} that is not supported. Skipping: {}", (Object)syncMode, (Object)errorMessage);
                }
            }
            return this;
        }

        public Builder setNodeId(String nodeId) {
            this.nodeId = nodeId;
            return this;
        }

        public Builder setNodeName(String nodeName) {
            this.nodeName = nodeName;
            return this;
        }

        public DirectorySynchronisationStatusImpl build() {
            return new DirectorySynchronisationStatusImpl(this);
        }
    }

    @FunctionalInterface
    public static interface StatusParametersMarshaller
    extends Function<List<Serializable>, String> {
    }
}

