/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.crowd.model.audit;

import com.atlassian.crowd.audit.AuditLogEntry;
import com.atlassian.crowd.model.audit.AuditLogChangesetEntity;
import java.util.Objects;
import java.util.StringJoiner;
import org.apache.commons.lang3.StringUtils;

public class AuditLogEntryEntity
implements AuditLogEntry {
    private Long id;
    private String propertyName = "";
    private String oldValue = "";
    private String newValue = "";
    private AuditLogChangesetEntity changeset;

    protected AuditLogEntryEntity() {
    }

    public AuditLogEntryEntity(String propertyName, String oldValue, String newValue) {
        this(null, propertyName, oldValue, newValue);
    }

    public AuditLogEntryEntity(Long id, String propertyName, String oldValue, String newValue) {
        this.id = id;
        this.propertyName = propertyName != null ? propertyName : "";
        this.oldValue = oldValue;
        this.newValue = newValue;
    }

    public AuditLogEntryEntity(Long id, String propertyName, String oldValue, String newValue, AuditLogChangesetEntity changeset) {
        this.id = id;
        this.propertyName = propertyName != null ? propertyName : "";
        this.oldValue = oldValue;
        this.newValue = newValue;
        this.changeset = changeset;
    }

    public AuditLogEntryEntity(AuditLogEntry auditLogEntry) {
        this(auditLogEntry.getPropertyName(), auditLogEntry.getOldValue(), auditLogEntry.getNewValue());
    }

    public Long getId() {
        return this.id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public String getPropertyName() {
        return this.propertyName;
    }

    public void setPropertyName(String propertyName) {
        this.propertyName = StringUtils.trimToEmpty((String)propertyName);
    }

    public String getOldValue() {
        return this.oldValue;
    }

    public void setOldValue(String oldValue) {
        this.oldValue = oldValue;
    }

    public String getNewValue() {
        return this.newValue;
    }

    public void setNewValue(String newValue) {
        this.newValue = newValue;
    }

    public AuditLogChangesetEntity getChangeset() {
        return this.changeset;
    }

    public void setChangeset(AuditLogChangesetEntity changeset) {
        this.changeset = changeset;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AuditLogEntryEntity that = (AuditLogEntryEntity)o;
        return Objects.equals(this.getId(), that.getId()) && Objects.equals(this.getPropertyName(), that.getPropertyName()) && Objects.equals(this.getOldValue(), that.getOldValue()) && Objects.equals(this.getNewValue(), that.getNewValue());
    }

    public int hashCode() {
        return Objects.hash(this.getId(), this.getPropertyName(), this.getOldValue(), this.getNewValue());
    }

    public String toString() {
        return new StringJoiner(", ", AuditLogEntryEntity.class.getSimpleName() + "[", "]").add("id=" + this.id).add("propertyName='" + this.propertyName + "'").add("oldValue='" + this.oldValue + "'").add("newValue='" + this.newValue + "'").toString();
    }
}

