/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.crowd.directory.password.constraint;

import com.atlassian.crowd.embedded.api.PasswordConstraint;
import com.atlassian.crowd.embedded.api.PasswordScore;
import com.atlassian.crowd.embedded.api.PasswordScoreService;
import com.atlassian.crowd.embedded.api.User;
import com.atlassian.crowd.embedded.api.ValidatePasswordRequest;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.apache.commons.lang3.StringUtils;

public class PasswordScoreConstraint
implements PasswordConstraint {
    private static final String WORD_BOUNDARY_REGEX = "(?=\\b)";
    private final PasswordScore minimumPasswordScore;
    private final PasswordScoreService passwordScoreService;

    public PasswordScoreConstraint(PasswordScore passwordScore, PasswordScoreService passwordScoreService) {
        if (passwordScore == null) {
            throw new NullPointerException("passwordScore cannot be null");
        }
        this.minimumPasswordScore = passwordScore;
        if (passwordScoreService == null) {
            throw new NullPointerException("passwordScoreService cannot be null");
        }
        this.passwordScoreService = passwordScoreService;
    }

    public boolean validate(ValidatePasswordRequest request) {
        PasswordScore actualPasswordScore = this.passwordScoreService.getPasswordScore(request.getPassword(), this.getUserInfo(request));
        return actualPasswordScore.isAtLeast(this.minimumPasswordScore);
    }

    public PasswordScore getMinimumPasswordScore() {
        return this.minimumPasswordScore;
    }

    public String toString() {
        return "PasswordScoreConstraint(minimum=" + this.minimumPasswordScore + ")";
    }

    private Collection<String> getUserInfo(ValidatePasswordRequest request) {
        User user = request.getUser();
        ArrayList<String> userInfo = new ArrayList<String>();
        userInfo.addAll(this.splitOnWordBoundary(user.getName()));
        userInfo.addAll(this.splitOnWordBoundary(user.getDisplayName()));
        userInfo.addAll(this.splitOnWordBoundary(user.getEmailAddress()));
        return userInfo;
    }

    private List<String> splitOnWordBoundary(String string) {
        if (StringUtils.isBlank((CharSequence)string)) {
            return Collections.emptyList();
        }
        return Arrays.asList(string.split(WORD_BOUNDARY_REGEX));
    }
}

