/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.crowd.search.util;

import com.atlassian.crowd.search.query.entity.EntityQuery;
import com.atlassian.crowd.search.util.ResultsAggregator;
import com.atlassian.crowd.search.util.ResultsAggregators;
import java.util.List;
import java.util.Optional;

public class QuerySplitter {
    public static <T, E extends Exception> List<T> batchConditionsIfNeeded(EntityQuery<T> query, Searcher<T, E> searcher, int maxRestrictionsPerQuery) throws E {
        Optional split = query.splitOrRestrictionIfNeeded(maxRestrictionsPerQuery);
        if (split.isPresent()) {
            ResultsAggregator<T> aggregator = ResultsAggregators.with(query);
            for (EntityQuery singleQuery : (List)split.get()) {
                aggregator.addAll(searcher.search(singleQuery));
            }
            return aggregator.constrainResults();
        }
        return searcher.search(query);
    }

    public static interface Searcher<T, E extends Exception> {
        public List<T> search(EntityQuery<T> var1) throws E;
    }
}

