package com.atlassian.crowd.embedded.api;

/**
 * A rating of a password based on estimated difficulty of cracking by some
 * {@link PasswordScoreService}.
 */
public enum PasswordScore {
    UNKNOWN(-1),
    WEAK(0),
    FAIR(1),
    GOOD(2),
    STRONG(3),
    VERY_STRONG(4);

    public static PasswordScore fromRanking(long ranking) {
        for (PasswordScore score : PasswordScore.values()) {
            if (score.ranking == ranking) {
                return score;
            }
        }
        throw new IllegalArgumentException("Ranking " + ranking + " does not correspond to valid password score's ranking");
    }

    private final int ranking; //used to persist to DB, and also enforce ordering

    private PasswordScore(int ranking) {
        this.ranking = ranking;
    }

    /**
     * Uses an internal ranking to compare the scores and determine if it is 'just as strong'.
     * It will return true if this score is greater than or equal to the parameter.
     * Note that this means UNKNOWN is at least as strong as UNKNOWN.
     *
     * @param minimumScore the score to compare to
     * @return If this score is at least as strong as the score being passed in
     */
    public boolean isAtLeast(PasswordScore minimumScore) {
        return ranking >= minimumScore.ranking;
    }

    public long getRanking() {
        return ranking;
    }
}
