package com.atlassian.crowd.exception;

/**
 * Thrown when a directory mapping could not be found for the given pair application and directory ids.
 *
 * @since v3.1.0
 */
public class DirectoryMappingNotFoundException extends ObjectNotFoundException {
    private final long applicationId;
    private final long directoryId;

    public DirectoryMappingNotFoundException(long applicationId, long directoryId) {
        super(String.format("The directory mapping between application <%d> and directory <%d> does not exist",
                applicationId,
                directoryId)
        );
        this.applicationId = applicationId;
        this.directoryId = directoryId;
    }

    public long getApplicationId() {
        return applicationId;
    }

    public long getDirectoryId() {
        return directoryId;
    }
}
