/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.devrel.servlet;

import com.atlassian.devrel.plugin.PlatformComponents;
import com.atlassian.devrel.servlet.RequiresAdminServlet;
import com.atlassian.plugin.PluginAccessor;
import com.atlassian.sal.api.ApplicationProperties;
import com.atlassian.sal.api.UrlMode;
import com.atlassian.sal.api.auth.LoginUriProvider;
import com.atlassian.sal.api.user.UserManager;
import com.atlassian.templaterenderer.TemplateRenderer;
import com.google.common.collect.Maps;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;

public class HomepageServlet
extends RequiresAdminServlet {
    private static final String HOMEPAGE_TEMPLATE = "/templates/homepage.vm";
    private static final String I18N_AVAILABLE_KEY = "i18nAvailable";
    private static final String I18N_STATE_KEY = "i18nActive";
    private static final String SDK_VERSION_KEY = "sdkVersion";
    private static final String SPEAKEASY_AVAILABLE_KEY = "speakeasyAvailable";
    private static final String ACTIVEOBJECTS_AVAILABLE_KEY = "aoAvailable";
    private static final String PLUGIN_DATA_EDITOR_AVAILABLE_KEY = "pdeAvailable";
    private static final String SYSTEM_INFO_LINK_KEY = "systemInfoLink";
    private static final String PLATFORM_COMPONENTS_KEY = "platformComponents";
    private static final String JAVADOC_KEY = "javadocUrl";
    private static final String APP_DOC_KEY = "appDevUrl";
    private static final String DISPLAY_NAME = "displayName";
    private static final String VERSION_KEY = "version";
    private static final String BASEURL_KEY = "baseUrl";
    private static final String PRODUCT_KEY = "product";
    private static final String DOWNLOAD_KEY = "downloadUrl";
    private static final String JAVADOC_TEMPLATE = "http://developer.atlassian.com/static/javadoc/%s/%s?utm_source=developer-toolbox-plugin&utm_medium=homepage-link&utm_campaign=developer-toolbox";
    private static final String BITBUCKET_DOC_TEMPLATE = "https://developer.atlassian.com/bitbucket/server/docs/%s";
    private static final String STASH_DOC_TEMPLATE = "https://developer.atlassian.com/stash/docs/%s";
    private static final String DOC_TEMPLATE = "http://developer.atlassian.com/display/%s?utm_source=developer-toolbox-plugin&utm_medium=homepage-link&utm_campaign=developer-toolbox";
    private static final String DOWNLOAD_TEMPLATE = "http://www.atlassian.com/software/%s/download?utm_source=developer-toolbox-plugin&utm_medium=homepage-link&utm_campaign=developer-toolbox";
    private final ApplicationProperties applicationProperties;
    private final PluginAccessor pluginAccessor;
    private final PlatformComponents platformComponents;

    public HomepageServlet(UserManager userManager, TemplateRenderer renderer, LoginUriProvider loginUriProvider, ApplicationProperties applicationProperties, PluginAccessor pluginAccessor, PlatformComponents platformComponents) {
        super(userManager, renderer, loginUriProvider);
        this.applicationProperties = applicationProperties;
        this.pluginAccessor = pluginAccessor;
        this.platformComponents = platformComponents;
    }

    @Override
    public Map<String, Object> getContext(HttpServletRequest req) {
        HashMap context = Maps.newHashMap();
        Application application = Application.getApplication(this.applicationProperties);
        boolean available = this.isI18nTranslationAvailable(application);
        context.put(I18N_AVAILABLE_KEY, available);
        if (available) {
            context.put(I18N_STATE_KEY, this.getI18nState(req, application));
        }
        context.put(SDK_VERSION_KEY, this.getSdkVersion());
        context.put(SPEAKEASY_AVAILABLE_KEY, this.isSpeakeasyAvailable());
        context.put(ACTIVEOBJECTS_AVAILABLE_KEY, this.isActiveObjectsAvailable());
        context.put(PLUGIN_DATA_EDITOR_AVAILABLE_KEY, this.isPluginDataEditorAvailable());
        context.put(SYSTEM_INFO_LINK_KEY, this.getSystemInfoLink(application));
        context.put(PLATFORM_COMPONENTS_KEY, this.platformComponents.getPlatformComponents());
        context.put(JAVADOC_KEY, this.getJavadocLink(application));
        context.put(APP_DOC_KEY, this.getAppDevDocLink(application));
        context.put(DISPLAY_NAME, this.getDisplayName(application));
        context.put(VERSION_KEY, this.applicationProperties.getVersion());
        context.put(BASEURL_KEY, this.getBaseUrl());
        context.put(PRODUCT_KEY, application == null ? "" : application.name().toLowerCase(Locale.ENGLISH));
        context.put(DOWNLOAD_KEY, this.getDownloadUrl(application));
        return context;
    }

    private String getDownloadUrl(Application application) {
        if (application == null) {
            return String.format(DOWNLOAD_TEMPLATE, this.applicationProperties.getDisplayName().toLowerCase(Locale.ENGLISH));
        }
        if (application == Application.STASH) {
            application = Application.BITBUCKET;
        }
        return String.format(DOWNLOAD_TEMPLATE, application.name().toLowerCase(Locale.ENGLISH));
    }

    @Override
    public String getTemplatePath() {
        return HOMEPAGE_TEMPLATE;
    }

    private boolean isI18nTranslationAvailable(Application application) {
        return application == Application.JIRA || application == Application.CONFLUENCE;
    }

    private boolean getI18nState(HttpServletRequest req, Application application) {
        Object o;
        HttpSession session = req.getSession(false);
        if (application == Application.JIRA) {
            return session.getAttribute("com.atlassian.jira.util.i18n.I18nTranslationModeSwitch") != null;
        }
        if (application == Application.CONFLUENCE && (o = session.getAttribute("confluence.i18n.mode")) != null) {
            return o.getClass().getSimpleName().equals("LightningTranslationMode");
        }
        return false;
    }

    private String getAppDevDocLink(Application application) {
        if (application == Application.BITBUCKET) {
            return String.format(BITBUCKET_DOC_TEMPLATE, this.applicationProperties.getVersion());
        }
        if (application == Application.STASH) {
            return String.format(STASH_DOC_TEMPLATE, this.applicationProperties.getVersion());
        }
        String spaceNameForProduct = application == Application.FISHEYE || application == Application.CRUCIBLE ? "FECRUDEV" : (application == Application.CONFLUENCE ? "CONFDEV" : (application == null ? this.applicationProperties.getDisplayName().toUpperCase(Locale.ENGLISH) : application.name() + "DEV"));
        return String.format(DOC_TEMPLATE, spaceNameForProduct);
    }

    private String getJavadocLink(Application application) {
        String javadocContext = application == null ? this.applicationProperties.getDisplayName().toLowerCase(Locale.ENGLISH) : (application == Application.BITBUCKET ? "bitbucket-server" : application.name().toLowerCase(Locale.ENGLISH));
        return String.format(JAVADOC_TEMPLATE, javadocContext, this.applicationProperties.getVersion());
    }

    private String getSdkVersion() {
        return System.getProperty("atlassian.sdk.version", "3.7 or earlier");
    }

    private boolean isSpeakeasyAvailable() {
        return this.pluginAccessor.getEnabledPlugin("com.atlassian.labs.speakeasy-plugin") != null;
    }

    private boolean isActiveObjectsAvailable() {
        return this.pluginAccessor.getEnabledPlugin("com.atlassian.activeobjects.activeobjects-plugin") != null;
    }

    private boolean isPluginDataEditorAvailable() {
        return this.pluginAccessor.getEnabledPlugin("com.atlassian.plugins.plugin-data-editor") != null;
    }

    private String getSystemInfoLink(Application application) {
        if (application == Application.JIRA) {
            return this.getBaseUrl() + "/secure/admin/ViewSystemInfo.jspa";
        }
        if (application == Application.CONFLUENCE || application == Application.BAMBOO) {
            return this.getBaseUrl() + "/admin/systeminfo.action";
        }
        if (application == Application.FISHEYE || application == Application.CRUCIBLE) {
            return this.getBaseUrl() + "/admin/sysinfo.do";
        }
        return null;
    }

    private String getBaseUrl() {
        return this.applicationProperties.getBaseUrl(UrlMode.RELATIVE);
    }

    private String getDisplayName(Application application) {
        String name = this.applicationProperties.getDisplayName();
        if (application == Application.BITBUCKET) {
            return name + " Server";
        }
        return name;
    }

    private static enum Application {
        JIRA,
        CONFLUENCE,
        FISHEYE,
        CRUCIBLE,
        BAMBOO,
        STASH,
        BITBUCKET;


        private static Application getApplication(ApplicationProperties properties) {
            String displayName = properties.getDisplayName();
            for (Application application : Application.values()) {
                if (!application.name().equalsIgnoreCase(displayName)) continue;
                return application;
            }
            return null;
        }
    }
}

