package com.atlassian.diagnostics.internal.platform.monitor.operatingsystem.ram;

import com.atlassian.diagnostics.internal.platform.analytics.ram.LowRamEventFactory;
import com.atlassian.diagnostics.internal.platform.monitor.operatingsystem.OperatingSystemMonitor;
import com.atlassian.diagnostics.internal.platform.monitor.operatingsystem.OperatingSystemMonitorConfiguration;
import com.atlassian.diagnostics.internal.platform.poller.DiagnosticPoller;
import com.atlassian.event.api.EventPublisher;

import javax.annotation.Nonnull;

public class RamPoller extends DiagnosticPoller<OperatingSystemMonitorConfiguration> {

    private final OperatingSystemMonitor operatingSystemMonitor;
    private final EventPublisher eventPublisher;
    private final RamInformationProvider ramInformationProvider;
    private final LowRamEventFactory lowRamEventFactory;

    public RamPoller(@Nonnull final OperatingSystemMonitor operatingSystemMonitor,
                     @Nonnull final OperatingSystemMonitorConfiguration operatingSystemMonitorConfiguration,
                     @Nonnull final EventPublisher eventPublisher,
                     @Nonnull final RamInformationProvider ramInformationProvider,
                     @Nonnull final LowRamEventFactory lowRamEventFactory) {
        super(RamPoller.class.getName(), operatingSystemMonitorConfiguration);
        this.operatingSystemMonitor = operatingSystemMonitor;
        this.eventPublisher = eventPublisher;
        this.ramInformationProvider = ramInformationProvider;
        this.lowRamEventFactory = lowRamEventFactory;
    }

    @Override
    protected void execute() {
        final long freeMemoryInMegabytes = ramInformationProvider.freeMemory();
        final long minimumMegabytesOfRam = monitorConfiguration.minimumMegabytesOfRam();
        if (freeMemoryInMegabytes < minimumMegabytesOfRam) {
            final long totalMemoryInMegabytes = ramInformationProvider.totalMemory();
            operatingSystemMonitor.alertLowFreeMemory(freeMemoryInMegabytes, totalMemoryInMegabytes, minimumMegabytesOfRam);

            if (lowRamEventFactory.isEnabled()) {
                eventPublisher.publish(lowRamEventFactory.create(freeMemoryInMegabytes, totalMemoryInMegabytes, minimumMegabytesOfRam));
            }
        }
    }
}
