package com.atlassian.dragonfly.api;

import com.atlassian.applinks.api.ApplicationLink;

import java.net.URI;

public interface ApplicationLinkConfigurator
{
    /**
     * Configures application links between the application and JIRA.
     *
     * Steps involves:-
     * - Creating a 2-way application link from the application to JIRA.
     * - Configuring application link authentication mechanism.
     *
     * @param jiraUrl url of the remote JIRA instance
     * @param localUrl url of the application as accessible by the remote JIRA
     * @param username JIRA admin username
     * @param password JIRA admin password
     *
     * @return the newly created application link
     * @throws JiraIntegrationConfigurationException if anything went wrong, also in which case all the applied configurations will be rolled back.
     */
    ApplicationLink configureApplicationLinks(URI jiraUrl, URI localUrl, String username, String password) throws JiraIntegrationConfigurationException;

    /**
     * Rolls back the configured application links between the application and JIRA.
     * This can be called only after {@link #configureApplicationLinks(java.net.URI, java.net.URI, String, String)} has already been called once.
     *
     * @param applicationLink the configured application link
     */
    void rollbackApplicationLinkConfiguration(ApplicationLink applicationLink);
}
