package com.atlassian.dragonfly.core;

import com.atlassian.applinks.api.application.jira.JiraApplicationType;
import com.atlassian.applinks.spi.Manifest;
import com.atlassian.applinks.spi.application.TypeId;
import com.atlassian.applinks.spi.link.MutatingApplicationLinkService;
import com.atlassian.applinks.spi.manifest.ManifestNotFoundException;
import com.atlassian.applinks.spi.manifest.ManifestRetriever;
import com.atlassian.applinks.spi.util.TypeAccessor;
import com.atlassian.dragonfly.api.JiraAccessUtil;
import com.atlassian.sal.api.net.ResponseException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import java.net.URI;

public class JiraAccessUtilImpl implements JiraAccessUtil
{
    private static final Logger LOG = LoggerFactory.getLogger(JiraAccessUtilImpl.class);

    private final ManifestRetriever manifestRetriever;
    private final TypeAccessor typeAccessor;
    private final MutatingApplicationLinkService applicationLinkService;

    public JiraAccessUtilImpl(ManifestRetriever manifestRetriever, TypeAccessor typeAccessor, MutatingApplicationLinkService applicationLinkService)
    {
        this.manifestRetriever = manifestRetriever;
        this.typeAccessor = typeAccessor;
        this.applicationLinkService = applicationLinkService;
    }

    public boolean checkTargetIsSupportedJira(URI remoteUrl)
    {
        final Manifest manifest;
        try
        {
            manifest = manifestRetriever.getManifest(remoteUrl);
        }
        catch (ManifestNotFoundException e)
        {
            LOG.info("Failed to retrieve manifest from " + remoteUrl, e);
            return false;
        }

        if (!manifest.getTypeId().equals(TypeId.getTypeId(typeAccessor.getApplicationType(JiraApplicationType.class))))
        {
            LOG.info(remoteUrl + " is not Jira");
            return false;
        }

        // we don't need to test the version String as (lucky for us) JIRA 4.3 was the first version to ship UAL.
        return true;
    }

    public boolean checkAdminCredential(URI remoteUrl, String username, String password)
    {
        try
        {
            return applicationLinkService.isAdminUserInRemoteApplication(remoteUrl, username, password);
        }
        catch (ResponseException e)
        {
            return false;
        }
    }
}
