/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.event.internal;

import com.atlassian.event.api.EventPublisher;
import com.atlassian.event.config.ListenerHandlersConfiguration;
import com.atlassian.event.internal.ClassUtils;
import com.atlassian.event.spi.EventDispatcher;
import com.atlassian.event.spi.ListenerHandler;
import com.atlassian.event.spi.ListenerInvoker;
import com.atlassian.util.concurrent.NotNull;
import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import com.google.common.collect.MapMaker;
import java.util.Set;
import java.util.concurrent.ConcurrentMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class LockFreeEventPublisher
implements EventPublisher {
    private final InvokerBuilder invokerBuilder;
    private final Publisher publisher;
    private final Listeners listeners = new Listeners();

    public LockFreeEventPublisher(EventDispatcher eventDispatcher, ListenerHandlersConfiguration listenerHandlersConfiguration) {
        this.invokerBuilder = new InvokerBuilder(((ListenerHandlersConfiguration)Preconditions.checkNotNull((Object)listenerHandlersConfiguration)).getListenerHandlers());
        this.publisher = new Publisher(eventDispatcher, this.listeners);
    }

    @Override
    public void publish(@NotNull Object event) {
        Preconditions.checkNotNull((Object)event);
        this.publisher.dispatch(event);
    }

    @Override
    public void register(@NotNull Object listener) {
        Preconditions.checkNotNull((Object)listener);
        this.listeners.register(listener, this.invokerBuilder.build(listener));
    }

    @Override
    public void unregister(@NotNull Object listener) {
        Preconditions.checkNotNull((Object)listener);
        this.listeners.remove(listener);
    }

    @Override
    public void unregisterAll() {
        this.listeners.clear();
    }

    static final class InvokerBuilder {
        private final Iterable<ListenerHandler> listenerHandlers;

        InvokerBuilder(@NotNull Iterable<ListenerHandler> listenerHandlers) {
            this.listenerHandlers = (Iterable)Preconditions.checkNotNull(listenerHandlers);
        }

        Iterable<ListenerInvoker> build(Object listener) throws IllegalArgumentException {
            ImmutableList.Builder builder = ImmutableList.builder();
            for (ListenerHandler listenerHandler : this.listenerHandlers) {
                builder.addAll(listenerHandler.getInvokers(listener));
            }
            ImmutableList invokers = builder.build();
            if (invokers.isEmpty()) {
                throw new IllegalArgumentException("No listener invokers were found for listener <" + listener + ">");
            }
            return invokers;
        }
    }

    static final class Publisher {
        private final Logger log = LoggerFactory.getLogger(this.getClass());
        private final Listeners listeners;
        private final EventDispatcher dispatcher;
        private final Function<Class, Iterable<ListenerInvoker>> eventClassToInvokersTransformer = new Function<Class, Iterable<ListenerInvoker>>(){

            public Iterable<ListenerInvoker> apply(Class eventClass) {
                return Publisher.this.listeners.get(eventClass);
            }
        };

        Publisher(EventDispatcher dispatcher, Listeners listeners) {
            this.dispatcher = (EventDispatcher)Preconditions.checkNotNull((Object)dispatcher);
            this.listeners = (Listeners)Preconditions.checkNotNull((Object)listeners);
        }

        public void dispatch(Object event) {
            for (ListenerInvoker invoker : this.getInvokers(event)) {
                try {
                    this.dispatcher.dispatch(invoker, event);
                }
                catch (Exception e) {
                    this.log.error("There was an exception thrown trying to dispatch event '" + event + "' from the invoker '" + invoker + "'.", (Throwable)e);
                }
            }
        }

        Iterable<ListenerInvoker> getInvokers(Object event) {
            Set<Class<?>> allEventTypes = ClassUtils.findAllTypes(event.getClass());
            return ImmutableSet.copyOf((Iterable)Iterables.concat((Iterable)Iterables.transform(allEventTypes, this.eventClassToInvokersTransformer)));
        }
    }

    static final class Invokers {
        private final ConcurrentMap<Object, ListenerInvoker> listeners = new MapMaker().weakKeys().makeMap();

        Invokers() {
        }

        Iterable<ListenerInvoker> all() {
            return this.listeners.values();
        }

        public void remove(Object key) {
            this.listeners.remove(key);
        }

        public void add(Object key, ListenerInvoker invoker) {
            this.listeners.put(key, invoker);
        }
    }

    static final class Listeners {
        private final ConcurrentMap<Class<?>, Invokers> invokers = new MapMaker().makeComputingMap(new Function<Class<?>, Invokers>(){

            public Invokers apply(Class<?> from) {
                return new Invokers();
            }
        });

        Listeners() {
        }

        void register(Object listener, Iterable<ListenerInvoker> invokers) {
            for (ListenerInvoker invoker : invokers) {
                this.register(listener, invoker);
            }
        }

        private void register(Object listener, ListenerInvoker invoker) {
            if (invoker.getSupportedEventTypes().isEmpty()) {
                ((Invokers)this.invokers.get(Object.class)).add(listener, invoker);
            } else {
                for (Class<?> eventClass : invoker.getSupportedEventTypes()) {
                    ((Invokers)this.invokers.get(eventClass)).add(listener, invoker);
                }
            }
        }

        void remove(Object listener) {
            for (Invokers entry : this.invokers.values()) {
                entry.remove(listener);
            }
        }

        void clear() {
            this.invokers.clear();
        }

        public Iterable<ListenerInvoker> get(Class<?> eventClass) {
            return ((Invokers)this.invokers.get(eventClass)).all();
        }
    }
}

