/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.http.mime;

import com.atlassian.http.mime.ContentDispositionHeaderGuesser;
import java.util.HashMap;
import java.util.Map;

public class DownloadHeaderHelper {
    private String contentDisposition;
    private String contentType;
    private static final Map<String, String> CONSTANT_HEADER = Map.of("X-Content-Type-Options", "nosniff", "X-Download-Options", "noopen");

    public DownloadHeaderHelper(ContentDispositionHeaderGuesser contentDispositionHeaderGuesser, String fileName, String contentType, String userAgent) {
        this.contentType = contentType;
        this.contentDisposition = contentDispositionHeaderGuesser.guessContentDispositionHeader(fileName, this.contentType, userAgent);
    }

    public DownloadHeaderHelper(String contentDisposition, String fileName, String contentType) {
        this.contentDisposition = contentDisposition;
        this.contentType = contentType;
    }

    public DownloadHeaderHelper(String contentDisposition, String contentType) {
        this(contentDisposition, null, contentType);
    }

    public HashMap<String, String> getDownloadHeaders() {
        HashMap<String, String> headers = new HashMap<String, String>();
        headers.putAll(CONSTANT_HEADER);
        headers.put("Content-Type", this.contentType);
        headers.put("Content-Disposition", this.contentDisposition);
        return headers;
    }

    public String getContentDisposition() {
        return this.contentDisposition;
    }

    public String getContentType() {
        return this.contentType;
    }
}

