/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.avatar;

import com.atlassian.annotations.ExperimentalApi;
import com.atlassian.jira.avatar.RequestedAvatarFormat;
import com.atlassian.jira.util.dbc.Assertions;
import javax.annotation.ParametersAreNonnullByDefault;

@ExperimentalApi
@ParametersAreNonnullByDefault
public class AvatarFormatParams {
    private final RequestedAvatarFormat requestedFormat;
    private final boolean strict;

    private AvatarFormatParams(RequestedAvatarFormat requestedFormat, boolean strict) {
        this.requestedFormat = Assertions.notNull("requestedFormat", requestedFormat);
        this.strict = strict;
    }

    public static AvatarFormatParams of(RequestedAvatarFormat requestedFormat) {
        return new AvatarFormatParams(requestedFormat, false);
    }

    public AvatarFormatParams strict() {
        return new AvatarFormatParams(this.requestedFormat, true);
    }

    public RequestedAvatarFormat getRequestedFormat() {
        return this.requestedFormat;
    }

    public boolean isStrict() {
        return this.strict;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof AvatarFormatParams)) {
            return false;
        }
        AvatarFormatParams that = (AvatarFormatParams)o;
        if (this.strict != that.strict) {
            return false;
        }
        return this.requestedFormat == that.requestedFormat;
    }

    public int hashCode() {
        int result = this.requestedFormat.hashCode();
        result = 31 * result + (this.strict ? 1 : 0);
        return result;
    }
}

