/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.avatar;

import com.atlassian.annotations.ExperimentalApi;
import com.atlassian.jira.avatar.Avatar;
import javax.annotation.Nonnull;
import javax.mail.internet.ContentType;
import javax.mail.internet.ParseException;

@ExperimentalApi
public enum RequestedAvatarFormat {
    DEFAULT{

        @Override
        public ContentType getResponseContentType(@Nonnull Avatar avatar) {
            try {
                return new ContentType(avatar.getContentType());
            }
            catch (ParseException e) {
                throw new RuntimeException(e);
            }
        }

        @Override
        public boolean isSupportedBy(@Nonnull Avatar avatar) {
            return true;
        }
    }
    ,
    PNG{

        @Override
        public ContentType getResponseContentType(@Nonnull Avatar avatar) {
            try {
                if (this.isSupportedBy(avatar)) {
                    return new ContentType("image/png");
                }
                return new ContentType(avatar.getContentType());
            }
            catch (ParseException e) {
                throw new RuntimeException(e);
            }
        }

        @Override
        public boolean isSupportedBy(@Nonnull Avatar avatar) {
            return "image/png".equals(avatar.getContentType()) || "image/svg+xml".equals(avatar.getContentType()) && avatar.isSystemAvatar();
        }
    };


    public abstract ContentType getResponseContentType(@Nonnull Avatar var1);

    public abstract boolean isSupportedBy(@Nonnull Avatar var1);
}

