/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.web.action;

import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.jira.user.util.Users;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import javax.servlet.http.HttpServletRequest;

public class AjaxHeaders {
    private static final String X_AUSERNAME = "X-AUSERNAME";
    private static final String X_PJAX = "X-PJAX";

    public static boolean requestUsernameMatches(HttpServletRequest request, ApplicationUser user) {
        String username = request.getHeader(X_AUSERNAME);
        if (username == null) {
            return true;
        }
        try {
            username = URLDecoder.decode(username, "UTF-8");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            // empty catch block
        }
        if (Users.isAnonymous(user)) {
            return "".equals(username);
        }
        return username.equals(user.getName());
    }

    public static boolean isPjaxRequest(HttpServletRequest request) {
        return Boolean.valueOf(request.getHeader(X_PJAX));
    }
}

