/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.util;

import com.atlassian.fugue.Option;
import com.atlassian.jira.util.ExecutorServiceWrapper;
import com.atlassian.jira.util.Supplier;
import com.atlassian.util.concurrent.ExecutorSubmitter;
import com.atlassian.util.concurrent.Promise;
import com.atlassian.util.concurrent.ThreadFactories;
import com.google.common.base.Preconditions;
import com.google.common.util.concurrent.ListeningExecutorService;
import com.google.common.util.concurrent.MoreExecutors;
import java.util.concurrent.Callable;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import javax.annotation.Nonnull;
import org.joda.time.Duration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class BoundedExecutorServiceWrapper
implements ExecutorServiceWrapper {
    private static final Logger log = LoggerFactory.getLogger(BoundedExecutorServiceWrapper.class);
    private final ListeningExecutorService executor;
    private final Duration shutdownTimeout;
    private final ExecutorSubmitter executorSubmitter;

    private BoundedExecutorServiceWrapper(int concurrency, @Nonnull Duration shutdownTimeout, @Nonnull String threadPoolName) {
        this(BoundedExecutorServiceWrapper.defaultExecutor(threadPoolName), concurrency, shutdownTimeout);
    }

    private BoundedExecutorServiceWrapper(@Nonnull ListeningExecutorService executor, int queueLength, @Nonnull Duration shutdownTimeout) {
        Preconditions.checkArgument((queueLength > 0 ? 1 : 0) != 0);
        this.executor = (ListeningExecutorService)Preconditions.checkNotNull((Object)executor);
        this.shutdownTimeout = (Duration)Preconditions.checkNotNull((Object)shutdownTimeout);
        this.executorSubmitter = com.atlassian.util.concurrent.Executors.submitter((Executor)com.atlassian.util.concurrent.Executors.limited((Executor)executor, (int)queueLength));
    }

    @Override
    public <O> Promise<O> submit(Callable<O> job) {
        return this.executorSubmitter.submit(job);
    }

    @Override
    public boolean awaitTermination() {
        return this.awaitTermination(this.shutdownTimeout.getMillis(), TimeUnit.MILLISECONDS);
    }

    @Override
    public boolean awaitTermination(long timeout, TimeUnit unit) {
        try {
            this.executor.shutdown();
            if (!this.executor.awaitTermination(timeout, unit)) {
                log.info("Concurrent processor executor service did not shutdown in {} {}. Killing.", (Object)timeout, (Object)unit);
                this.executor.shutdownNow();
            }
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
        }
        return this.executor.isTerminated();
    }

    @Override
    public boolean isTerminated() {
        return this.executor.isTerminated();
    }

    private static ListeningExecutorService defaultExecutor(String threadPoolName) {
        return MoreExecutors.listeningDecorator((ExecutorService)Executors.newCachedThreadPool(ThreadFactories.namedThreadFactory((String)threadPoolName)));
    }

    public static class Builder {
        private int concurrency = 5;
        private Duration shutdownTimeout = Duration.millis((long)60000L);
        private String threadPoolName = "concurrent-processor-pool";
        private Option<Supplier<ListeningExecutorService>> executorServiceSupplier;

        public Builder withConcurrency(int concurrency) {
            Preconditions.checkArgument((concurrency > 0 ? 1 : 0) != 0, (Object)"Concurrency must be greater than 0");
            this.concurrency = concurrency;
            this.executorServiceSupplier = Option.none();
            return this;
        }

        public Builder withShutdownTimeout(@Nonnull Duration shutdownTimeout) {
            this.shutdownTimeout = (Duration)Preconditions.checkNotNull((Object)shutdownTimeout);
            return this;
        }

        public Builder withThreadPoolName(@Nonnull String threadPoolName) {
            Preconditions.checkArgument((threadPoolName != null && threadPoolName.length() > 0 ? 1 : 0) != 0, (Object)"Thread pool name must not be empty");
            this.threadPoolName = threadPoolName;
            this.executorServiceSupplier = Option.none();
            return this;
        }

        public Builder withExecutorService(@Nonnull Supplier<ListeningExecutorService> executorServiceSupplier) {
            Preconditions.checkNotNull(executorServiceSupplier);
            this.executorServiceSupplier = Option.some(executorServiceSupplier);
            return this;
        }

        public BoundedExecutorServiceWrapper build() {
            if (this.executorServiceSupplier.isDefined()) {
                return new BoundedExecutorServiceWrapper((ListeningExecutorService)((Supplier)this.executorServiceSupplier.get()).get(), this.concurrency, this.shutdownTimeout);
            }
            return new BoundedExecutorServiceWrapper(this.concurrency, this.shutdownTimeout, this.threadPoolName);
        }
    }
}

