/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.rest.client.internal.async;

import com.atlassian.httpclient.api.HttpClient;
import com.atlassian.jira.rest.client.api.MetadataRestClient;
import com.atlassian.jira.rest.client.api.domain.Field;
import com.atlassian.jira.rest.client.api.domain.IssueType;
import com.atlassian.jira.rest.client.api.domain.IssuelinksType;
import com.atlassian.jira.rest.client.api.domain.Priority;
import com.atlassian.jira.rest.client.api.domain.Resolution;
import com.atlassian.jira.rest.client.api.domain.ServerInfo;
import com.atlassian.jira.rest.client.api.domain.Status;
import com.atlassian.jira.rest.client.internal.async.AbstractAsynchronousRestClient;
import com.atlassian.jira.rest.client.internal.json.FieldJsonParser;
import com.atlassian.jira.rest.client.internal.json.GenericJsonArrayParser;
import com.atlassian.jira.rest.client.internal.json.IssueLinkTypesJsonParser;
import com.atlassian.jira.rest.client.internal.json.IssueTypeJsonParser;
import com.atlassian.jira.rest.client.internal.json.JsonArrayParser;
import com.atlassian.jira.rest.client.internal.json.PriorityJsonParser;
import com.atlassian.jira.rest.client.internal.json.ResolutionJsonParser;
import com.atlassian.jira.rest.client.internal.json.ServerInfoJsonParser;
import com.atlassian.jira.rest.client.internal.json.StatusJsonParser;
import com.atlassian.util.concurrent.Promise;
import java.net.URI;
import javax.ws.rs.core.UriBuilder;

public class AsynchronousMetadataRestClient
extends AbstractAsynchronousRestClient
implements MetadataRestClient {
    private static final String SERVER_INFO_RESOURCE = "/serverInfo";
    private final ServerInfoJsonParser serverInfoJsonParser = new ServerInfoJsonParser();
    private final IssueTypeJsonParser issueTypeJsonParser = new IssueTypeJsonParser();
    private final GenericJsonArrayParser<IssueType> issueTypesJsonParser = GenericJsonArrayParser.create(this.issueTypeJsonParser);
    private final StatusJsonParser statusJsonParser = new StatusJsonParser();
    private final GenericJsonArrayParser<Status> statusesJsonParser = GenericJsonArrayParser.create(this.statusJsonParser);
    private final PriorityJsonParser priorityJsonParser = new PriorityJsonParser();
    private final GenericJsonArrayParser<Priority> prioritiesJsonParser = GenericJsonArrayParser.create(this.priorityJsonParser);
    private final ResolutionJsonParser resolutionJsonParser = new ResolutionJsonParser();
    private final GenericJsonArrayParser<Resolution> resolutionsJsonParser = GenericJsonArrayParser.create(this.resolutionJsonParser);
    private final IssueLinkTypesJsonParser issueLinkTypesJsonParser = new IssueLinkTypesJsonParser();
    private final JsonArrayParser<Iterable<Field>> fieldsJsonParser = FieldJsonParser.createFieldsArrayParser();
    private final URI baseUri;

    public AsynchronousMetadataRestClient(URI baseUri, HttpClient httpClient) {
        super(httpClient);
        this.baseUri = baseUri;
    }

    public Promise<IssueType> getIssueType(URI uri) {
        return this.getAndParse(uri, this.issueTypeJsonParser);
    }

    public Promise<Iterable<IssueType>> getIssueTypes() {
        URI uri = UriBuilder.fromUri((URI)this.baseUri).path("issuetype").build(new Object[0]);
        return this.getAndParse(uri, this.issueTypesJsonParser);
    }

    public Promise<Iterable<IssuelinksType>> getIssueLinkTypes() {
        URI uri = UriBuilder.fromUri((URI)this.baseUri).path("issueLinkType").build(new Object[0]);
        return this.getAndParse(uri, this.issueLinkTypesJsonParser);
    }

    public Promise<Status> getStatus(URI uri) {
        return this.getAndParse(uri, this.statusJsonParser);
    }

    public Promise<Iterable<Status>> getStatuses() {
        URI uri = UriBuilder.fromUri((URI)this.baseUri).path("status").build(new Object[0]);
        return this.getAndParse(uri, this.statusesJsonParser);
    }

    public Promise<Priority> getPriority(URI uri) {
        return this.getAndParse(uri, this.priorityJsonParser);
    }

    public Promise<Iterable<Priority>> getPriorities() {
        URI uri = UriBuilder.fromUri((URI)this.baseUri).path("priority").build(new Object[0]);
        return this.getAndParse(uri, this.prioritiesJsonParser);
    }

    public Promise<Resolution> getResolution(URI uri) {
        return this.getAndParse(uri, this.resolutionJsonParser);
    }

    public Promise<Iterable<Resolution>> getResolutions() {
        URI uri = UriBuilder.fromUri((URI)this.baseUri).path("resolution").build(new Object[0]);
        return this.getAndParse(uri, this.resolutionsJsonParser);
    }

    public Promise<ServerInfo> getServerInfo() {
        URI serverInfoUri = UriBuilder.fromUri((URI)this.baseUri).path(SERVER_INFO_RESOURCE).build(new Object[0]);
        return this.getAndParse(serverInfoUri, this.serverInfoJsonParser);
    }

    public Promise<Iterable<Field>> getFields() {
        URI uri = UriBuilder.fromUri((URI)this.baseUri).path("field").build(new Object[0]);
        return this.getAndParse(uri, this.fieldsJsonParser);
    }
}

