/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.rest.client.internal.async;

import com.atlassian.jira.rest.client.api.AuditRestClient;
import com.atlassian.jira.rest.client.api.ComponentRestClient;
import com.atlassian.jira.rest.client.api.GroupRestClient;
import com.atlassian.jira.rest.client.api.IssueRestClient;
import com.atlassian.jira.rest.client.api.JiraRestClient;
import com.atlassian.jira.rest.client.api.MetadataRestClient;
import com.atlassian.jira.rest.client.api.MyPermissionsRestClient;
import com.atlassian.jira.rest.client.api.ProjectRestClient;
import com.atlassian.jira.rest.client.api.ProjectRolesRestClient;
import com.atlassian.jira.rest.client.api.SearchRestClient;
import com.atlassian.jira.rest.client.api.SessionRestClient;
import com.atlassian.jira.rest.client.api.UserRestClient;
import com.atlassian.jira.rest.client.api.VersionRestClient;
import com.atlassian.jira.rest.client.api.domain.util.UriUtil;
import com.atlassian.jira.rest.client.internal.async.AsynchronousAuditRestClient;
import com.atlassian.jira.rest.client.internal.async.AsynchronousCloudSearchRestClient;
import com.atlassian.jira.rest.client.internal.async.AsynchronousComponentRestClient;
import com.atlassian.jira.rest.client.internal.async.AsynchronousGroupRestClient;
import com.atlassian.jira.rest.client.internal.async.AsynchronousIssueRestClient;
import com.atlassian.jira.rest.client.internal.async.AsynchronousMetadataRestClient;
import com.atlassian.jira.rest.client.internal.async.AsynchronousMyPermissionsRestClient;
import com.atlassian.jira.rest.client.internal.async.AsynchronousProjectRestClient;
import com.atlassian.jira.rest.client.internal.async.AsynchronousProjectRolesRestClient;
import com.atlassian.jira.rest.client.internal.async.AsynchronousSearchRestClient;
import com.atlassian.jira.rest.client.internal.async.AsynchronousSessionRestClient;
import com.atlassian.jira.rest.client.internal.async.AsynchronousUserRestClient;
import com.atlassian.jira.rest.client.internal.async.AsynchronousVersionRestClient;
import com.atlassian.jira.rest.client.internal.async.DisposableHttpClient;
import jakarta.ws.rs.core.UriBuilder;
import java.io.IOException;
import java.net.URI;

public class AsynchronousJiraRestClient
implements JiraRestClient {
    private final IssueRestClient issueRestClient;
    private final SessionRestClient sessionRestClient;
    private final UserRestClient userRestClient;
    private final GroupRestClient groupRestClient;
    private final ProjectRestClient projectRestClient;
    private final ComponentRestClient componentRestClient;
    private final MetadataRestClient metadataRestClient;
    private final SearchRestClient searchRestClient;
    private final VersionRestClient versionRestClient;
    private final ProjectRolesRestClient projectRolesRestClient;
    private final MyPermissionsRestClient myPermissionsRestClient;
    private final DisposableHttpClient httpClient;
    private final AuditRestClient auditRestClient;

    public AsynchronousJiraRestClient(URI serverUri, DisposableHttpClient httpClient) {
        this(serverUri, httpClient, UriUtil.isURICloud((URI)serverUri));
    }

    public AsynchronousJiraRestClient(URI serverUri, DisposableHttpClient httpClient, boolean isCloudVersion) {
        URI baseUri = UriBuilder.fromUri((URI)serverUri).path("/rest/api/latest").build(new Object[0]);
        this.httpClient = httpClient;
        this.metadataRestClient = new AsynchronousMetadataRestClient(baseUri, httpClient);
        this.sessionRestClient = new AsynchronousSessionRestClient(serverUri, httpClient);
        this.issueRestClient = new AsynchronousIssueRestClient(baseUri, httpClient, this.sessionRestClient, this.metadataRestClient);
        this.userRestClient = new AsynchronousUserRestClient(baseUri, httpClient);
        this.groupRestClient = new AsynchronousGroupRestClient(baseUri, httpClient);
        this.projectRestClient = new AsynchronousProjectRestClient(baseUri, httpClient);
        this.componentRestClient = new AsynchronousComponentRestClient(baseUri, httpClient);
        this.searchRestClient = isCloudVersion ? new AsynchronousCloudSearchRestClient(baseUri, httpClient) : new AsynchronousSearchRestClient(baseUri, httpClient);
        this.versionRestClient = new AsynchronousVersionRestClient(baseUri, httpClient);
        this.projectRolesRestClient = new AsynchronousProjectRolesRestClient(serverUri, httpClient);
        this.myPermissionsRestClient = new AsynchronousMyPermissionsRestClient(baseUri, httpClient);
        this.auditRestClient = new AsynchronousAuditRestClient(httpClient, baseUri);
    }

    public IssueRestClient getIssueClient() {
        return this.issueRestClient;
    }

    public SessionRestClient getSessionClient() {
        return this.sessionRestClient;
    }

    public UserRestClient getUserClient() {
        return this.userRestClient;
    }

    public GroupRestClient getGroupClient() {
        return this.groupRestClient;
    }

    public ProjectRestClient getProjectClient() {
        return this.projectRestClient;
    }

    public ComponentRestClient getComponentClient() {
        return this.componentRestClient;
    }

    public MetadataRestClient getMetadataClient() {
        return this.metadataRestClient;
    }

    public SearchRestClient getSearchClient() {
        return this.searchRestClient;
    }

    public VersionRestClient getVersionRestClient() {
        return this.versionRestClient;
    }

    public ProjectRolesRestClient getProjectRolesRestClient() {
        return this.projectRolesRestClient;
    }

    public MyPermissionsRestClient getMyPermissionsRestClient() {
        return this.myPermissionsRestClient;
    }

    public AuditRestClient getAuditRestClient() {
        return this.auditRestClient;
    }

    public void close() throws IOException {
        try {
            this.httpClient.destroy();
        }
        catch (Exception e) {
            throw e instanceof IOException ? (IOException)e : new IOException(e);
        }
    }
}

