/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.rest.client.internal.async;

import com.atlassian.httpclient.api.HttpClient;
import com.atlassian.jira.rest.client.api.UserRestClient;
import com.atlassian.jira.rest.client.api.domain.User;
import com.atlassian.jira.rest.client.api.domain.input.UserInput;
import com.atlassian.jira.rest.client.internal.async.AbstractAsynchronousRestClient;
import com.atlassian.jira.rest.client.internal.json.UserJsonParser;
import com.atlassian.jira.rest.client.internal.json.UsersJsonParser;
import com.atlassian.jira.rest.client.internal.json.gen.UserInputJsonGenerator;
import io.atlassian.util.concurrent.Promise;
import jakarta.ws.rs.core.UriBuilder;
import java.net.URI;
import javax.annotation.Nullable;

public class AsynchronousUserRestClient
extends AbstractAsynchronousRestClient
implements UserRestClient {
    private static final String USER_URI_PREFIX = "user";
    private static final String SEARCH_URI_PREFIX = "search";
    private static final String USERNAME_ATTRIBUTE = "username";
    private static final String START_AT_ATTRIBUTE = "startAt";
    private static final String MAX_RESULTS_ATTRIBUTE = "maxResults";
    private static final String INCLUDE_ACTIVE_ATTRIBUTE = "includeActive";
    private static final String INCLUDE_INACTIVE_ATTRIBUTE = "includeInactive";
    private final UserJsonParser userJsonParser = new UserJsonParser();
    private final UsersJsonParser usersJsonParser = new UsersJsonParser();
    private final URI baseUri;

    public AsynchronousUserRestClient(URI baseUri, HttpClient client) {
        super(client);
        this.baseUri = baseUri;
    }

    public Promise<User> getUser(String username) {
        URI userUri = UriBuilder.fromUri((URI)this.baseUri).path(USER_URI_PREFIX).queryParam(USERNAME_ATTRIBUTE, new Object[]{username}).queryParam("expand", new Object[]{"groups"}).build(new Object[0]);
        return this.getUser(userUri);
    }

    public Promise<User> getUser(URI userUri) {
        return this.getAndParse(userUri, this.userJsonParser);
    }

    public Promise<User> createUser(UserInput user) {
        UriBuilder uriBuilder = UriBuilder.fromUri((URI)this.baseUri).path(USER_URI_PREFIX);
        return this.postAndParse(uriBuilder.build(new Object[0]), user, new UserInputJsonGenerator(), this.userJsonParser);
    }

    public Promise<User> updateUser(URI userUri, UserInput user) {
        return this.putAndParse(userUri, user, new UserInputJsonGenerator(), this.userJsonParser);
    }

    public Promise<Void> removeUser(URI userUri) {
        return this.delete(userUri);
    }

    public Promise<Iterable<User>> findUsers(String username) {
        return this.findUsers(username, null, null, null, null);
    }

    public Promise<Iterable<User>> findUsers(String username, @Nullable Integer startAt, @Nullable Integer maxResults, @Nullable Boolean includeActive, @Nullable Boolean includeInactive) {
        UriBuilder uriBuilder = UriBuilder.fromUri((URI)this.baseUri).path(USER_URI_PREFIX).path(SEARCH_URI_PREFIX).queryParam(USERNAME_ATTRIBUTE, new Object[]{username});
        this.addOptionalQueryParam(uriBuilder, START_AT_ATTRIBUTE, startAt);
        this.addOptionalQueryParam(uriBuilder, MAX_RESULTS_ATTRIBUTE, maxResults);
        this.addOptionalQueryParam(uriBuilder, INCLUDE_ACTIVE_ATTRIBUTE, includeActive);
        this.addOptionalQueryParam(uriBuilder, INCLUDE_INACTIVE_ATTRIBUTE, includeInactive);
        URI usersUri = uriBuilder.build(new Object[0]);
        return this.getAndParse(usersUri, this.usersJsonParser);
    }

    private void addOptionalQueryParam(UriBuilder uriBuilder, String key, Object value) {
        if (value != null) {
            uriBuilder.queryParam(key, new Object[]{value});
        }
    }
}

