/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.labs.restbrowser.provider;

import com.atlassian.jira.util.BuildUtilsInfo;
import com.atlassian.labs.restbrowser.plugin.SoapService;
import com.atlassian.labs.restbrowser.provider.Jira6SoapServiceProvider;
import com.atlassian.labs.restbrowser.provider.SoapServiceProvider;
import com.atlassian.plugin.PluginAccessor;
import com.google.common.collect.Lists;
import org.springframework.beans.factory.FactoryBean;

public class JiraSoapServiceProviderFactory
implements FactoryBean {
    private final BuildUtilsInfo buildUtilsInfo;
    private final PluginAccessor pluginAccessor;

    public JiraSoapServiceProviderFactory(BuildUtilsInfo buildUtilsInfo, PluginAccessor pluginAccessor) {
        this.buildUtilsInfo = buildUtilsInfo;
        this.pluginAccessor = pluginAccessor;
    }

    public SoapServiceProvider getObject() throws Exception {
        int[] versionNumbers = this.buildUtilsInfo.getVersionNumbers();
        if (versionNumbers != null) {
            int majorVersion = versionNumbers[0];
            if (majorVersion >= 7) {
                return new NoopSoapServiceProvider();
            }
            return new Jira6SoapServiceProvider(this.pluginAccessor);
        }
        return new NoopSoapServiceProvider();
    }

    public Class<?> getObjectType() {
        return SoapServiceProvider.class;
    }

    public boolean isSingleton() {
        return true;
    }

    private static class NoopSoapServiceProvider
    implements SoapServiceProvider {
        private NoopSoapServiceProvider() {
        }

        @Override
        public Iterable<? extends SoapService> getSoapServices() {
            return Lists.newArrayList();
        }
    }
}

