/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.labs.restbrowser.servlet;

import com.atlassian.sal.api.auth.LoginUriProvider;
import com.atlassian.sal.api.user.UserManager;
import com.atlassian.templaterenderer.TemplateRenderer;
import com.google.common.base.Preconditions;
import java.io.IOException;
import java.io.Writer;
import java.net.URI;
import java.util.Map;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public abstract class RequiresLoginServlet
extends HttpServlet {
    private final UserManager userManager;
    private final TemplateRenderer renderer;
    private final LoginUriProvider loginUriProvider;
    private static final String RAB_ANONYMOUS = "rest.api.browser.anonymous";

    public RequiresLoginServlet(UserManager userManager, TemplateRenderer renderer, LoginUriProvider loginUriProvider) {
        this.userManager = (UserManager)Preconditions.checkNotNull((Object)userManager, (Object)"userManager");
        this.renderer = (TemplateRenderer)Preconditions.checkNotNull((Object)renderer, (Object)"renderer");
        this.loginUriProvider = (LoginUriProvider)Preconditions.checkNotNull((Object)loginUriProvider, (Object)"loginUriProvider");
    }

    public abstract String getTemplatePath();

    public abstract Map<String, Object> getContext(HttpServletRequest var1);

    protected final void doGet(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        String username;
        if (!Boolean.getBoolean(RAB_ANONYMOUS) && (username = this.userManager.getRemoteUsername(req)) == null) {
            this.redirectToLogin(req, resp);
            return;
        }
        resp.setContentType("text/html;charset=utf-8");
        this.renderer.render(this.getTemplatePath(), this.getContext(req), (Writer)resp.getWriter());
    }

    private void redirectToLogin(HttpServletRequest request, HttpServletResponse response) throws IOException {
        response.sendRedirect(this.loginUriProvider.getLoginUri(this.getUri(request)).toASCIIString());
    }

    private URI getUri(HttpServletRequest request) {
        StringBuffer builder = request.getRequestURL();
        if (request.getQueryString() != null) {
            builder.append("?");
            builder.append(request.getQueryString());
        }
        return URI.create(builder.toString());
    }
}

