/*
 * Decompiled with CFR 0.152.
 */
package org.ofbiz.core.entity.transaction;

import java.sql.Connection;
import java.sql.SQLException;
import javax.transaction.Transaction;
import javax.transaction.TransactionManager;
import javax.transaction.UserTransaction;
import org.ofbiz.core.entity.ConnectionFactory;
import org.ofbiz.core.entity.GenericEntityException;
import org.ofbiz.core.entity.config.DatasourceInfo;
import org.ofbiz.core.entity.config.EntityConfigUtil;
import org.ofbiz.core.entity.transaction.TransactionFactoryInterface;
import org.ofbiz.core.util.Debug;

public class DumbFactory
implements TransactionFactoryInterface {
    @Override
    public TransactionManager getTransactionManager() {
        return DumbTransactionManager.INSTANCE;
    }

    @Override
    public UserTransaction getUserTransaction() {
        return DumbUserTransaction.INSTANCE;
    }

    @Override
    public String getTxMgrName() {
        return "dumb";
    }

    @Override
    public Connection getConnection(String helperName) throws SQLException, GenericEntityException {
        DatasourceInfo datasourceInfo = EntityConfigUtil.getInstance().getDatasourceInfo(helperName);
        if (datasourceInfo.getJdbcDatasource() == null) {
            Debug.logError((String)("Dumb/Empty is the configured transaction manager but no inline-jdbc element was specified in the " + helperName + " datasource. Please check your configuration"));
            return null;
        }
        return ConnectionFactory.tryGenericConnectionSources(helperName, datasourceInfo.getJdbcDatasource());
    }

    @Override
    public void removeDatasource(String helperName) {
        ConnectionFactory.removeDatasource(helperName);
    }

    static class DumbUserTransaction
    implements UserTransaction {
        static final DumbUserTransaction INSTANCE = new DumbUserTransaction();

        DumbUserTransaction() {
        }

        public void begin() {
        }

        public void commit() {
        }

        public int getStatus() {
            return 6;
        }

        public void rollback() {
        }

        public void setRollbackOnly() {
        }

        public void setTransactionTimeout(int i) {
        }
    }

    static class DumbTransactionManager
    implements TransactionManager {
        static final DumbTransactionManager INSTANCE = new DumbTransactionManager();

        DumbTransactionManager() {
        }

        public void begin() {
        }

        public void commit() {
        }

        public int getStatus() {
            return 6;
        }

        public Transaction getTransaction() {
            return null;
        }

        public void resume(Transaction transaction) {
        }

        public void rollback() {
        }

        public void setRollbackOnly() {
        }

        public void setTransactionTimeout(int i) {
        }

        public Transaction suspend() {
            return null;
        }
    }
}

