/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.plugin.spring.scanner.core;

import com.atlassian.plugin.spring.scanner.ProductFilter;
import com.atlassian.plugin.spring.scanner.annotation.component.BambooComponent;
import com.atlassian.plugin.spring.scanner.annotation.component.BitbucketComponent;
import com.atlassian.plugin.spring.scanner.annotation.component.ClasspathComponent;
import com.atlassian.plugin.spring.scanner.annotation.component.ConfluenceComponent;
import com.atlassian.plugin.spring.scanner.annotation.component.FecruComponent;
import com.atlassian.plugin.spring.scanner.annotation.component.JiraComponent;
import com.atlassian.plugin.spring.scanner.annotation.component.RefappComponent;
import com.atlassian.plugin.spring.scanner.annotation.component.Scanned;
import com.atlassian.plugin.spring.scanner.annotation.component.StashComponent;
import com.atlassian.plugin.spring.scanner.annotation.export.ExportAsDevService;
import com.atlassian.plugin.spring.scanner.annotation.export.ExportAsService;
import com.atlassian.plugin.spring.scanner.annotation.export.ModuleType;
import com.atlassian.plugin.spring.scanner.annotation.imports.BambooImport;
import com.atlassian.plugin.spring.scanner.annotation.imports.BitbucketImport;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.atlassian.plugin.spring.scanner.annotation.imports.ConfluenceImport;
import com.atlassian.plugin.spring.scanner.annotation.imports.FecruImport;
import com.atlassian.plugin.spring.scanner.annotation.imports.JiraImport;
import com.atlassian.plugin.spring.scanner.annotation.imports.RefappImport;
import com.atlassian.plugin.spring.scanner.annotation.imports.StashImport;
import com.atlassian.plugin.spring.scanner.core.vfs.VirtualFile;
import com.atlassian.plugin.spring.scanner.core.vfs.VirtualFileFactory;
import com.google.common.base.Function;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Maps;
import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import javax.annotation.Nullable;
import javax.annotation.processing.Filer;
import javax.inject.Named;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang.StringUtils;
import org.springframework.stereotype.Component;
import org.springframework.stereotype.Controller;
import org.springframework.stereotype.Repository;
import org.springframework.stereotype.Service;

public class SpringIndexWriter {
    private final Map<String, RecordedAnnotations> recordedProfiles = new HashMap<String, RecordedAnnotations>();
    private final VirtualFileFactory fileFactory;

    public SpringIndexWriter(String baseDir) {
        this.cleanDirectory(new File(baseDir, "META-INF/plugin-components"));
        this.fileFactory = new VirtualFileFactory(new File(baseDir));
    }

    public SpringIndexWriter(Filer filer) {
        this.fileFactory = new VirtualFileFactory(filer);
    }

    public boolean isInteresting(String annotationType) {
        return null != MeaningfulAnnotation.fromCanonicalName(annotationType);
    }

    public boolean isParameterOrFieldAnnotation(String annotationType) {
        MeaningfulAnnotation meaningfulAnnotation = MeaningfulAnnotation.fromCanonicalName(annotationType);
        return null != meaningfulAnnotation && meaningfulAnnotation.parameterOrFieldAnnotation;
    }

    public void encounteredAnnotation(Set<String> targetProfiles, String annotationType, String nameFromAnnotation, String className) {
        HashSet<String> profiles = new HashSet<String>(targetProfiles);
        if (profiles.isEmpty()) {
            profiles.add("default");
        }
        for (String profile : profiles) {
            RecordedAnnotations recordedAnnotations = this.recordedProfiles.get(profile);
            if (recordedAnnotations == null) {
                recordedAnnotations = new RecordedAnnotations();
                this.recordedProfiles.put(profile, recordedAnnotations);
            }
            recordedAnnotations.record(annotationType, nameFromAnnotation, className);
        }
    }

    public void writeIndexes() {
        for (Map.Entry<String, RecordedAnnotations> annotationsEntry : this.recordedProfiles.entrySet()) {
            this.writeProfileIndexes(annotationsEntry.getKey(), annotationsEntry.getValue());
        }
    }

    private void writeProfileIndexes(String profileName, RecordedAnnotations annotations) {
        HashMap<String, TreeSet<String>> fileNameToComponents = new HashMap<String, TreeSet<String>>();
        for (Map.Entry<MeaningfulAnnotation, Set<String>> entry : annotations.getRecordedAnnotations().entrySet()) {
            MeaningfulAnnotation meaningfulAnnotation = entry.getKey();
            if (!meaningfulAnnotation.isWrittenToDisk()) continue;
            Set<String> perAnnotationComponents = entry.getValue();
            String indexFileName = meaningfulAnnotation.getFileName();
            TreeSet<String> currentComponents = (TreeSet<String>)fileNameToComponents.get(indexFileName);
            if (currentComponents == null) {
                currentComponents = new TreeSet<String>();
                fileNameToComponents.put(indexFileName, currentComponents);
            }
            currentComponents.addAll(perAnnotationComponents);
        }
        for (Map.Entry<MeaningfulAnnotation, Set<String>> entry : fileNameToComponents.entrySet()) {
            try {
                this.writeIndexFile(profileName, (String)((Object)entry.getKey()), entry.getValue());
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
    }

    private void writeIndexFile(String profileName, String indexFileName, Set<String> entries) throws IOException {
        File file = this.makeProfiledFileName(profileName, indexFileName);
        VirtualFile vf = this.fileFactory.getFile(file.getPath());
        TreeSet<String> lines = new TreeSet<String>();
        lines.addAll(vf.readLines());
        lines.addAll(entries);
        vf.writeLines(lines);
    }

    private File makeProfiledFileName(String profileName, String fileName) throws IOException {
        File file = new File("profile-" + profileName, fileName);
        if ("default".equals(profileName)) {
            file = new File(fileName);
        }
        return new File("META-INF/plugin-components", file.getPath());
    }

    private void cleanDirectory(File destination) {
        if (destination.exists()) {
            try {
                FileUtils.deleteDirectory((File)destination);
            }
            catch (IOException e) {
                throw new RuntimeException("Unable to delete directory " + destination, e);
            }
        }
    }

    private class RecordedAnnotations {
        final Map<MeaningfulAnnotation, Set<String>> recordedAnnotations = new HashMap<MeaningfulAnnotation, Set<String>>();

        private RecordedAnnotations() {
        }

        public Map<MeaningfulAnnotation, Set<String>> getRecordedAnnotations() {
            return this.recordedAnnotations;
        }

        public void record(String annotationType, String nameFromAnnotation, String className) {
            MeaningfulAnnotation annotation;
            StringBuilder sb = new StringBuilder(className);
            if (StringUtils.isNotBlank((String)nameFromAnnotation)) {
                sb.append("#").append(nameFromAnnotation);
            }
            if (null == (annotation = MeaningfulAnnotation.fromCanonicalName(annotationType))) {
                throw new IllegalStateException("Stop asking me for the impossible. Annotation " + annotationType + " not found");
            }
            this.addTo(annotation, sb.toString());
        }

        private void addTo(MeaningfulAnnotation meaningfulAnnotation, String value) {
            Set<String> values = this.recordedAnnotations.get((Object)meaningfulAnnotation);
            if (values == null) {
                values = new TreeSet<String>();
                this.recordedAnnotations.put(meaningfulAnnotation, values);
            }
            values.add(value);
        }
    }

    private static enum MeaningfulAnnotation {
        Component("component", Component.class),
        Service("component", Service.class),
        Controller("component", Controller.class),
        Repository("component", Repository.class),
        Named("component", Named.class, true),
        ClasspathComponent("component", ClasspathComponent.class, true),
        BambooComponent(ProductFilter.BAMBOO.getPerProductFile("component"), BambooComponent.class, true),
        BitbucketComponent(ProductFilter.BITBUCKET.getPerProductFile("component"), BitbucketComponent.class, true),
        ConfluenceComponent(ProductFilter.CONFLUENCE.getPerProductFile("component"), ConfluenceComponent.class, true),
        JiraComponent(ProductFilter.JIRA.getPerProductFile("component"), JiraComponent.class, true),
        FecruComponent(ProductFilter.FECRU.getPerProductFile("component"), FecruComponent.class, true),
        RefappComponent(ProductFilter.REFAPP.getPerProductFile("component"), RefappComponent.class, true),
        StashComponent(ProductFilter.STASH.getPerProductFile("component"), StashComponent.class, true),
        Imports("imports", ComponentImport.class, true),
        BambooImports(ProductFilter.BAMBOO.getPerProductFile("imports"), BambooImport.class, true),
        BitbucketImports(ProductFilter.BITBUCKET.getPerProductFile("imports"), BitbucketImport.class, true),
        ConfluenceImports(ProductFilter.CONFLUENCE.getPerProductFile("imports"), ConfluenceImport.class, true),
        FecruImports(ProductFilter.FECRU.getPerProductFile("imports"), FecruImport.class, true),
        JiraImports(ProductFilter.JIRA.getPerProductFile("imports"), JiraImport.class, true),
        RefappImports(ProductFilter.REFAPP.getPerProductFile("imports"), RefappImport.class, true),
        StashImports(ProductFilter.STASH.getPerProductFile("imports"), StashImport.class, true),
        ExportAsService("exports", ExportAsService.class, true),
        ExportAsDevService("dev-exports", ExportAsDevService.class, true),
        ModuleType("exports", ModuleType.class),
        Scanned(Scanned.class);

        private static final Map<String, MeaningfulAnnotation> canonicalNameIndex;
        private final String fileName;
        private final Class forAnnotation;
        private final boolean parameterOrFieldAnnotation;

        private MeaningfulAnnotation(String fileName, Class forAnnotation) {
            this(fileName, forAnnotation, false);
        }

        private MeaningfulAnnotation(Class forAnnotation) {
            this(null, forAnnotation, false);
        }

        private MeaningfulAnnotation(String fileName, Class forAnnotation, boolean parameterOrFieldAnnotation) {
            this.fileName = fileName;
            this.forAnnotation = forAnnotation;
            this.parameterOrFieldAnnotation = parameterOrFieldAnnotation;
        }

        private static MeaningfulAnnotation fromCanonicalName(String annotationType) {
            return canonicalNameIndex.get(annotationType);
        }

        private String getFileName() {
            return this.fileName;
        }

        private boolean isWrittenToDisk() {
            return null != this.fileName;
        }

        static {
            canonicalNameIndex = Maps.uniqueIndex((Iterable)ImmutableList.copyOf((Object[])MeaningfulAnnotation.values()), (Function)new Function<MeaningfulAnnotation, String>(){

                public String apply(@Nullable MeaningfulAnnotation meaningfulAnnotation) {
                    return meaningfulAnnotation.forAnnotation.getCanonicalName();
                }
            });
        }
    }
}

