/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.plugin;

import com.atlassian.plugin.PluginArtifact;
import com.atlassian.plugin.PluginParseException;
import com.atlassian.plugin.ReferenceMode;
import com.google.common.base.Preconditions;
import com.google.common.collect.Iterators;
import com.google.common.collect.Sets;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import java.util.jar.JarFile;
import java.util.jar.Manifest;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.zip.ZipEntry;
import org.apache.commons.io.IOUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class JarPluginArtifact
implements PluginArtifact,
PluginArtifact.HasExtraModuleDescriptors {
    private static final Logger log = LoggerFactory.getLogger(JarPluginArtifact.class);
    private final File jarFile;
    final ReferenceMode referenceMode;

    public JarPluginArtifact(File jarFile) {
        this(jarFile, ReferenceMode.FORBID_REFERENCE);
    }

    public JarPluginArtifact(File jarFile, ReferenceMode referenceMode) {
        this.jarFile = (File)Preconditions.checkNotNull((Object)jarFile);
        this.referenceMode = referenceMode;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean doesResourceExist(String name) {
        InputStream in = null;
        try {
            in = this.getResourceAsStream(name);
            boolean bl = in != null;
            return bl;
        }
        finally {
            IOUtils.closeQuietly((InputStream)in);
        }
    }

    public InputStream getResourceAsStream(String fileName) throws PluginParseException {
        Preconditions.checkNotNull((Object)fileName, (Object)"The file name must not be null");
        final JarFile jar = this.open();
        ZipEntry entry = jar.getEntry(fileName);
        if (entry == null) {
            this.closeJarQuietly(jar);
            return null;
        }
        try {
            return new BufferedInputStream(jar.getInputStream(entry)){

                @Override
                public void close() throws IOException {
                    super.close();
                    jar.close();
                }
            };
        }
        catch (IOException e) {
            throw new PluginParseException("Cannot retrieve " + fileName + " from plugin JAR [" + this.jarFile + "]", (Throwable)e);
        }
    }

    public String getName() {
        return this.jarFile.getName();
    }

    public String toString() {
        return this.getName();
    }

    public InputStream getInputStream() {
        try {
            return new BufferedInputStream(new FileInputStream(this.jarFile));
        }
        catch (FileNotFoundException e) {
            throw new PluginParseException("Could not open JAR file: " + this.jarFile, (Throwable)e);
        }
    }

    public File toFile() {
        return this.jarFile;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean containsJavaExecutableCode() {
        JarFile jar = this.open();
        try {
            Manifest manifest = this.getManifest(jar);
            boolean bl = this.hasBundleActivator(manifest) || this.hasSpringContext(manifest) || Iterators.any((Iterator)Iterators.forEnumeration(jar.entries()), entry -> this.isJavaClass((ZipEntry)entry) || this.isJavaLibrary((ZipEntry)entry) || this.isSpringContext((ZipEntry)entry));
            return bl;
        }
        finally {
            this.closeJarQuietly(jar);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean containsSpringContext() {
        JarFile jar = this.open();
        try {
            Manifest manifest = this.getManifest(jar);
            boolean bl = this.hasSpringContext(manifest) || Iterators.any((Iterator)Iterators.forEnumeration(jar.entries()), this::isSpringContext);
            return bl;
        }
        finally {
            this.closeJarQuietly(jar);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set<String> extraModuleDescriptorFiles(String rootFolder) {
        JarFile jar = this.open();
        try {
            Matcher m = Pattern.compile(Pattern.quote(rootFolder) + "/[^/.]*\\.(?i)xml$").matcher("");
            HashSet hashSet = Sets.newHashSet((Iterator)Iterators.transform((Iterator)Iterators.filter((Iterator)Iterators.forEnumeration(jar.entries()), entry -> {
                m.reset(entry.getName());
                return m.find();
            }), jarEntry -> jarEntry.getName()));
            return hashSet;
        }
        finally {
            this.closeJarQuietly(jar);
        }
    }

    public ReferenceMode getReferenceMode() {
        return this.referenceMode;
    }

    private boolean isJavaClass(ZipEntry entry) {
        return entry.getName().endsWith(".class");
    }

    private boolean isJavaLibrary(ZipEntry entry) {
        return entry.getName().endsWith(".jar");
    }

    private boolean isSpringContext(ZipEntry entry) {
        String entryName = entry.getName();
        return entryName.startsWith("META-INF/spring/") && entryName.endsWith(".xml");
    }

    private boolean hasSpringContext(Manifest manifest) {
        return this.hasManifestEntry(manifest, "Spring-Context");
    }

    private boolean hasBundleActivator(Manifest manifest) {
        return this.hasManifestEntry(manifest, "Bundle-Activator");
    }

    private boolean hasManifestEntry(Manifest manifest, String manifestEntryName) {
        return manifest != null && manifest.getMainAttributes() != null && manifest.getMainAttributes().getValue(manifestEntryName) != null;
    }

    private JarFile open() {
        try {
            return new JarFile(this.jarFile);
        }
        catch (IOException e) {
            throw new PluginParseException("Cannot open JAR file: " + this.jarFile, (Throwable)e);
        }
    }

    private Manifest getManifest(JarFile jar) {
        try {
            return jar.getManifest();
        }
        catch (IOException e) {
            throw new PluginParseException("Cannot get manifest for JAR file: " + this.jarFile, (Throwable)e);
        }
    }

    private void closeJarQuietly(JarFile jar) {
        if (jar != null) {
            try {
                jar.close();
            }
            catch (IOException e) {
                log.debug("Exception closing jar file {}.", (Object)this.jarFile, (Object)e);
            }
        }
    }
}

