/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.plugin.descriptors;

import com.atlassian.plugin.ModuleDescriptor;
import com.atlassian.plugin.ModuleDescriptorFactory;
import com.atlassian.plugin.Plugin;
import com.atlassian.plugin.PluginParseException;
import com.atlassian.plugin.descriptors.UnloadableModuleDescriptor;
import org.dom4j.Element;

public final class UnloadableModuleDescriptorFactory {
    public static UnloadableModuleDescriptor createUnloadableModuleDescriptor(Plugin plugin, Element element, Throwable e, ModuleDescriptorFactory moduleDescriptorFactory) throws PluginParseException {
        UnloadableModuleDescriptor descriptor = new UnloadableModuleDescriptor();
        descriptor.init(plugin, element);
        String name = element.getName();
        Class descriptorClass = moduleDescriptorFactory.getModuleDescriptorClass(name);
        String descriptorClassName = descriptorClass == null ? descriptor.getKey() : descriptorClass.getName();
        String errorMsg = UnloadableModuleDescriptorFactory.constructErrorMessage(plugin, name, descriptorClassName, e);
        descriptor.setErrorText(errorMsg);
        return descriptor;
    }

    public static UnloadableModuleDescriptor createUnloadableModuleDescriptor(Plugin plugin, ModuleDescriptor<?> descriptor, Throwable e) {
        UnloadableModuleDescriptor unloadableDescriptor = new UnloadableModuleDescriptor();
        unloadableDescriptor.setName(descriptor.getName());
        unloadableDescriptor.setKey(descriptor.getKey());
        unloadableDescriptor.setPlugin(plugin);
        String errorMsg = UnloadableModuleDescriptorFactory.constructErrorMessage(plugin, descriptor.getDisplayName(), descriptor.getModuleClass() == null ? descriptor.getName() : descriptor.getModuleClass().getName(), e);
        unloadableDescriptor.setErrorText(errorMsg);
        return unloadableDescriptor;
    }

    private static String constructErrorMessage(Plugin plugin, String moduleName, String moduleClass, Throwable e) {
        String errorMsg = e instanceof PluginParseException ? "There was a problem loading the descriptor for module '" + moduleName + "' in plugin '" + (plugin == null ? "null" : plugin.getName()) + "'.\n " : (e instanceof InstantiationException ? "Could not instantiate module descriptor: " + moduleClass + ".<br/>" : (e instanceof IllegalAccessException ? "Exception instantiating module descriptor: " + moduleClass + ".<br/>" : (e instanceof ClassNotFoundException ? "Could not find module descriptor class: " + moduleClass + ".<br/>" : (e instanceof NoClassDefFoundError ? "A required class was missing: " + moduleClass + ". Please check that you have all of the required dependencies.<br/>" : "There was a problem loading the module descriptor: " + moduleClass + ".<br/>"))));
        return errorMsg + e.getMessage();
    }
}

