/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.plugin.osgi.hook.dmz.packages;

import com.atlassian.plugin.osgi.hook.dmz.PackageMatcher;
import com.atlassian.plugin.osgi.hook.dmz.packages.DmzPackagePatterns;
import com.atlassian.plugin.osgi.hook.dmz.packages.InternalPackageDetector;
import java.util.Optional;
import org.osgi.framework.wiring.BundleCapability;

public class DefaultInternalPackageDetector
implements InternalPackageDetector {
    static final String ATTR_WIRING_PACKAGE = "osgi.wiring.package";
    private final DmzPackagePatterns dmzPackagePatterns;

    public DefaultInternalPackageDetector(DmzPackagePatterns dmzPackagePatterns) {
        this.dmzPackagePatterns = dmzPackagePatterns;
    }

    private Optional<String> getWiringPackage(BundleCapability capability) {
        return Optional.ofNullable(capability.getAttributes().get(ATTR_WIRING_PACKAGE)).filter(String.class::isInstance).map(String.class::cast);
    }

    @Override
    public boolean isInternalPackage(BundleCapability capability) {
        return this.getWiringPackage(capability).map(wiringPackage -> {
            boolean isPublic = this.dmzPackagePatterns.getOsgiPublicPackages().stream().anyMatch(pattern -> new PackageMatcher((String)pattern, (String)wiringPackage).match());
            boolean isNotExcluded = this.dmzPackagePatterns.getOsgiPublicPackagesExcludes().stream().noneMatch(pattern -> new PackageMatcher((String)pattern, (String)wiringPackage).match());
            boolean publicPackage = isPublic && isNotExcluded;
            return !publicPackage;
        }).orElse(false);
    }

    @Override
    public boolean isDeprecatedPackage(BundleCapability capability) {
        return this.getWiringPackage(capability).map(wiringPackage -> this.dmzPackagePatterns.getOsgiDeprecatedPackages().stream().anyMatch(pattern -> new PackageMatcher((String)pattern, (String)wiringPackage).match())).orElse(false);
    }
}

