/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.plugin.osgi.hook.dmz.packages;

import com.atlassian.plugin.osgi.hook.dmz.packages.InternalPackageDetector;
import java.util.Arrays;
import java.util.List;
import org.osgi.framework.wiring.BundleCapability;

public class PluginInternalPackageDetector
implements InternalPackageDetector {
    public static final String ATTR_ATLASSIAN_ACCESS = "atlassian-access";
    public static final String ATLASSIAN_ACCESS_PUBLIC = "public";
    public static final String ATLASSIAN_ACCESS_DEPRECATED = "deprecated";
    public static final String ATLASSIAN_ACCESS_INTERNAL = "internal";
    public static final String ATLASSIAN_ACCESS_INHERITED = "inherited";
    public static final String ATLASSIAN_ACCESS_DEFAULT = "inherited";
    public static final List<String> ATLASSIAN_ACCESS_ALLOWED_VALUES = Arrays.asList("public", "deprecated", "internal", "inherited");
    private final InternalPackageDetector inheritedInternalPackageDetector;

    public PluginInternalPackageDetector(InternalPackageDetector inheritedInternalPackageDetector) {
        this.inheritedInternalPackageDetector = inheritedInternalPackageDetector;
    }

    @Override
    public boolean isInternalPackage(BundleCapability pluginExport) {
        String propertyValue = pluginExport.getAttributes().getOrDefault(ATTR_ATLASSIAN_ACCESS, "inherited");
        this.validateValue(propertyValue);
        if ("inherited".equals(propertyValue)) {
            return this.inheritedInternalPackageDetector.isInternalPackage(pluginExport);
        }
        return ATLASSIAN_ACCESS_INTERNAL.equals(propertyValue);
    }

    @Override
    public boolean isDeprecatedPackage(BundleCapability pluginExport) {
        String propertyValue = pluginExport.getAttributes().getOrDefault(ATTR_ATLASSIAN_ACCESS, "inherited");
        this.validateValue(propertyValue);
        if ("inherited".equals(propertyValue)) {
            return this.inheritedInternalPackageDetector.isDeprecatedPackage(pluginExport);
        }
        return ATLASSIAN_ACCESS_DEPRECATED.equals(propertyValue);
    }

    private void validateValue(String propertyValue) {
        if (ATLASSIAN_ACCESS_ALLOWED_VALUES.stream().noneMatch(allowedValue -> allowedValue.equals(propertyValue))) {
            throw new UnknownAtlassianAccessValue(propertyValue);
        }
    }

    public static class UnknownAtlassianAccessValue
    extends RuntimeException {
        public UnknownAtlassianAccessValue(String propertyValue) {
            super(String.format("Detected unknown value of the property '%s' set to '%s'", PluginInternalPackageDetector.ATTR_ATLASSIAN_ACCESS, propertyValue));
        }
    }
}

