/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.plugin.web.descriptors;

import com.atlassian.plugin.Plugin;
import com.atlassian.plugin.PluginParseException;
import com.atlassian.plugin.descriptors.AbstractModuleDescriptor;
import com.atlassian.plugin.hostcontainer.HostContainer;
import com.atlassian.plugin.module.ModuleFactory;
import com.atlassian.plugin.util.validation.ValidationPattern;
import com.atlassian.plugin.web.Condition;
import com.atlassian.plugin.web.ContextProvider;
import com.atlassian.plugin.web.WebInterfaceManager;
import com.atlassian.plugin.web.conditions.ConditionLoadingException;
import com.atlassian.plugin.web.descriptors.ConditionElementParser;
import com.atlassian.plugin.web.descriptors.ContextProviderElementParser;
import com.atlassian.plugin.web.descriptors.WebPanelModuleDescriptor;
import com.atlassian.plugin.web.descriptors.WebPanelSupplierFactory;
import com.atlassian.plugin.web.descriptors.WeightElementParser;
import com.atlassian.plugin.web.model.WebPanel;
import com.google.common.base.Supplier;
import java.util.HashMap;
import java.util.Map;
import org.dom4j.Element;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class DefaultWebPanelModuleDescriptor
extends AbstractModuleDescriptor<WebPanel>
implements WebPanelModuleDescriptor {
    public static final String XML_ELEMENT_NAME = "web-panel";
    private final WebInterfaceManager webInterfaceManager;
    private WebPanelSupplierFactory webPanelSupplierFactory;
    private Supplier<WebPanel> webPanelFactory;
    private Supplier<Condition> conditionFactory;
    private Supplier<ContextProvider> contextProviderFactory;
    private int weight;
    private String location;

    public DefaultWebPanelModuleDescriptor(HostContainer hostContainer, ModuleFactory moduleClassFactory, WebInterfaceManager webInterfaceManager) {
        super(moduleClassFactory);
        this.webPanelSupplierFactory = new WebPanelSupplierFactory(this, hostContainer, this.moduleFactory);
        this.webInterfaceManager = webInterfaceManager;
    }

    public void init(final Plugin plugin, final Element element) throws PluginParseException {
        super.init(plugin, element);
        this.weight = WeightElementParser.getWeight(element);
        this.location = element.attributeValue("location");
        this.conditionFactory = new Supplier<Condition>(){

            public Condition get() {
                return new ConditionElementParser(new ConditionElementParser.ConditionFactory(){

                    public Condition create(String className, Plugin plugin) throws ConditionLoadingException {
                        return DefaultWebPanelModuleDescriptor.this.webInterfaceManager.getWebFragmentHelper().loadCondition(className, plugin);
                    }
                }).makeConditions(plugin, element, 1);
            }
        };
        this.contextProviderFactory = new Supplier<ContextProvider>(){
            private ContextProvider contextProvider;

            public ContextProvider get() {
                if (this.contextProvider == null) {
                    this.contextProvider = new ContextProviderElementParser(DefaultWebPanelModuleDescriptor.this.webInterfaceManager.getWebFragmentHelper()).makeContextProvider(plugin, element);
                }
                return this.contextProvider;
            }
        };
        this.webPanelFactory = this.webPanelSupplierFactory.build(this.moduleClassName);
    }

    protected void provideValidationRules(ValidationPattern pattern) {
        super.provideValidationRules(pattern);
        pattern.rule(new ValidationPattern.RuleTest[]{ValidationPattern.test((String)"@location").withError("The Web Panel location attribute is required.")});
    }

    @Override
    public String getLocation() {
        return this.location;
    }

    @Override
    public int getWeight() {
        return this.weight;
    }

    @Override
    public Condition getCondition() {
        return (Condition)this.conditionFactory.get();
    }

    @Override
    public ContextProvider getContextProvider() {
        return (ContextProvider)this.contextProviderFactory.get();
    }

    public WebPanel getModule() {
        return new ContextAwareWebPanel((WebPanel)this.webPanelFactory.get());
    }

    public void enabled() {
        super.enabled();
        this.webInterfaceManager.refresh();
    }

    public void disabled() {
        this.webInterfaceManager.refresh();
        super.disabled();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class ContextAwareWebPanel
    implements WebPanel {
        private final WebPanel delegate;

        private ContextAwareWebPanel(WebPanel delegate) {
            this.delegate = delegate;
        }

        @Override
        public String getHtml(Map<String, Object> context) {
            return this.delegate.getHtml(DefaultWebPanelModuleDescriptor.this.getContextProvider().getContextMap(new HashMap<String, Object>(context)));
        }
    }
}

